$(function() {
    $("[title]").easyTooltip(); // Makes every item has "title" attribute displays using tooltip
    $("#tabbed").tabbed(); // Tabs script
    $(".tableSorter").tablesorter({
        selectorHeaders:'thead th:not(:first)'
    }); // Sorter table script

    // SlideUp blocks using blind effect.
    $('a.collapse').click(function(){
        var collapsedBlock = $(this).parent().parent().children(".collapsible");
        collapsedBlock.toggle('blind',300)
    });

    // Fade then SlideUp then remove from DOM function.
    $("a.close").click(function(){
        $(this).hide('fast');
        $(this).parent().fadeTo("slow", 0.00, function(){ //fade
            $(this).slideUp("normal", function() { //slide up
                $(this).remove(); //then remove from the DOM
            });
        });
    });

    // Small twick to fix floating bubble of "count"
    $("span.count").parent().css({
        "position":"relative"
    });

    $(document).ready(function() {
        // Flyout menu
        $('.menu1.sub li,.menu1.sub ul').hover(
            function(){
                $(this).children('ul').stop().animate({
                    left:-($(this).children('ul').outerWidth())
                    })
                },
            function(){
                $(this).children('ul').stop().animate({
                    left:0
                })
            });

        // Right Navigation scroll on hover script
        var calculatedHeight = $(window).height() - $('#rightNav').offset().top; // NEW: Set height dynamic
        $('#rightNav').hoverscroll({
            vertical: true,	// Display the list vertically or horizontally
            width:    208,	// Width of the list container
            height:   calculatedHeight,	// Height of the list container
            arrows:   true,	// Display direction indicator arrows or not
            arrowsOpacity: 0.8,	// Max possible opacity of the arrows
            fixedArrows: false, // Fixed arrows on the sides of the list (disables arrowsOpacity)
            rtl:      false,    // Print images from right to left
            debug:    false     // Debug output in the firebug console
        });

        // Initialize Cleditor plugin
        editor = $("#textEditor").cleditor({
            width:"60%",
            height:"60%"
        })[0].focus();

        // Initialize file upload style
        $('.form input[type=file]').bind('change focus click', SITE.fileInputs);

        // Select all checkboxes
        $(':checkbox[name=selectAll]').click (function () {
            var checkedStatus = this.checked;
            $(':checkbox[name=groupe]').each(function () {
                this.checked = checkedStatus;
            });
        //            $(':checkbox[name=groupe]').prop('checked', this.checked);alert("ok");
        });

        $("#search-input").autocomplete("democontent.html/", {
            matchContains: true,
            scrollHeight: 300,
            width: 610,
            selectFirst: false
        });
    });
});