<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class User_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    function all_users() {
        $result = $this->db->get('d_users');
        return $result->result_array();
    }

    function create() {
        $this->load->library('encrypt');
        $this->db->set("user_username", $this->input->post("user_username"));
        $this->db->set("user_full_name", $this->input->post("user_full_name"));
        $this->db->set("user_email", $this->input->post("user_email"));
        $this->db->set("user_branch_id", $this->input->post("user_branch_id"));
        $this->db->set("user_phone", $this->input->post("user_phone"));
        $this->db->set("user_notice", $this->input->post("user_notice"));
        $this->db->set("user_password", md5($this->input->post("user_password")));
        $this->db->set("user_created", time());
        $this->db->set('user_group_id', $this->input->post('user_group_id'));
        $this->db->insert("d_users");

        $id = $this->db->insert_id();
        $this->db->set('ug_user_id', $id);
        $this->db->set('ug_group_id', $this->input->post('user_group_id'));
        $this->db->insert('d_user_groups');
    }

    /**

     * @param integer $id

     */
    function update($id) {

        $this->db->where('user_id', $id);
        $this->db->set("user_username", $this->input->post("user_username"));
        $this->db->set("user_full_name", $this->input->post("user_full_name"));
        $this->db->set("user_email", $this->input->post("user_email"));
        $this->db->set("user_branch_id", $this->input->post("user_branch_id"));
        $this->db->set("user_phone", $this->input->post("user_phone"));
        $this->db->set("user_notice", $this->input->post("user_notice"));
        if ($this->input->post("user_password") !== '') {
            $this->db->set("user_password", md5($this->input->post("user_password")));
        }
        $this->db->set("user_created", time());
        $this->db->set('user_group_id', $this->input->post('user_group_id'));
        $this->db->update('d_users');

        $this->db->where('ug_user_id', $id);
        $this->db->set('ug_group_id', $this->input->post('user_group_id'));
        $this->db->update('d_user_groups');

        log_message('debug', 'user data updated for id =' . $id);
    }

    function get_user_one($id) {

        $result = $this->db->query("select 
                                    d_branch.*,
                                    d_users.*
                                    FROM d_users 
                                    LEFT JOIN d_branch ON d_users.user_branch_id = d_branch.branch_id
                                    where user_id='$id'");
        return $result->row();
    }

    /**

     *

     * @param integer $group_id

     *

     */
    function get_users_by_group($group_id) {

        $this->db->where('user_group_id', $group_id);

        return $this->db->get('users')->result_array();
    }

    /**

     *

     * @param integer $user_id

     *

     */
    function get_user_group($user_id) {

        $this->db->where('user_id', $user_id);

        return $this->db->get('d_users')->row();
    }

    function get_group_dropdown() {
        $this->db->select('gr_id, gr_name');
        $result = $this->db->get('d_groups');
        $return = array();
        if ($result->num_rows() > 0) {
            $return[''] = '--اختر--';    // default selection item
            foreach ($result->result_array() as $row) {
                $return[$row['gr_id']] = $row['gr_name'];
            }
        }

        return $return;
    }

    function get_all_users($row) {
        $result = $this->db->query(" SELECT * FROM d_users ORDER BY user_id ASC LIMIT $row,5");
        return $result->result_array();
    }

    function getNumUsers() {
        $query = $this->db->query("select * from d_users");
        return $query->num_rows();
    }

// end if advanced search
    ////////////////////////
    ///////////////////////////////////////////////

    function contactRequest($name, $email, $body) {
        $user_id = $this->session->userdata('id');

        $this->db->set('m_title', $this->input->post('name'));
        $this->db->set('m_mail_from', $this->input->post('email'));
        $this->db->set('m_body', $this->input->post('body'));
        $this->db->set('m_from', $user_id);
        $this->db->insert('mail');
    }

    function contactVisit() {
        $this->db->set('c_name', $this->input->post('name'));
        $this->db->set('c_mail', $this->input->post('email'));
        $this->db->set('c_body', $this->input->post('body'));
        $this->db->insert('visit');
    }

    function mail_list_v() {

    }

//===================================================================
    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('user_id', $products[$i]);
                        $this->db->set('user_state', '1');
                        $this->db->update('d_users');
                        break;
                    case "inactive":
                        $this->db->where('user_id', $products[$i]);
                        $this->db->set('user_state', '2');
                        $this->db->update('d_users');
                        break;
                    case "delete":
                        $this->db->where('user_id', $products[$i]);
                        $result = $this->db->get('d_users');
                        $r = $result->row();
                        if ($r->u_personal_image != null) {
                            if (file_exists(PUBPATH . "global/uploads/" . $r->u_personal_image)) {
                                unlink(PUBPATH . "global/uploads/" . $r->u_personal_image);
                            }
                        }
                        $this->db->where('user_id', $products[$i]);
                        $this->db->delete('d_users');
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('user_state', '1');
                    $this->db->update('d_users');
                    break;
                case "inactive":
                    $this->db->set('user_state', '2');
                    $this->db->update('d_users');
                    break;
                case "delete":
                    $result = $this->db->get('d_users');
                    $r = $result->result_array();
                    foreach ($r as $rm):
                        if ($rm['u_personal_image'] != null) {
                            if (file_exists(PUBPATH . "global/uploads/" . $rm['u_personal_image'])) {
                                unlink(PUBPATH . "global/uploads/" . $rm['u_personal_image']);
                            }
                        }
                        $this->db->delete('d_users');
                    endforeach;
                    break;
            }
        }
    }

    function get_users_one($id) {
        $this->db->where('user_id', $id);
        $result = $this->db->get('d_users');
        return $result->row();
    }

    function delete($id) {
        $this->db->where('user_id', $id);
        $this->db->delete('d_users');
        return TRUE;
    }

    //========================================================================
    // photo

    function myPhoto($user_id) {
        $q = $this->db->query("SELECT * FROM photo WHERE ph_user_id='$user_id' ");
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $data[] = $row;
            }
            return $data;
            return TRUE;
        } else
            return FALSE;
    }

    function selectdepartPhoto() {
        $q = $this->db->get('photo_sections');
        if ($q->num_rows() > 0) {
            foreach ($q->result() as $row) {
                $data[] = $row;
            }
            return $data;
            return TRUE;
        } else
            return FALSE;
    }

    function do_upload($ph_title, $section_id) {

        $config = array(
            'allowed_types' => 'jpg|jpeg|gif|png',
            'upload_path' => $this->sectiongallery_path,
            'max_size' => 2000
        );

        $this->load->library('upload', $config);
        $this->upload->do_upload();
        $image_data = $this->upload->data();

        $source = $image_data['file_name'];
        $uid = $this->session->userdata('id');
        $this->db->set('ph_user_id', $uid);
        $this->db->set('ph_title', $ph_title);
        $this->db->set('ph_url', $source);
        $this->db->set('ph_sec_id', $section_id);
        $this->db->insert('photo');



        $config = array(
            'source_image' => $image_data['full_path'],
            'new_image' => $this->sectiongallery_path . '/thumbs',
            'maintain_ration' => true,
            'width' => 300,
            'height' => 200
        );

        $this->load->library('image_lib', $config);
        $this->image_lib->resize();
    }

    // photo_category

    function get_categories() {
        $result = $this->db->get('photo_sections');
        return $result->result_array();
    }

    //======================================
    // photos_model

    function get_photos_category() {
        $result = $this->db->get('photo_sections');
        if ($result->num_rows() > 0) {
            $photos_category = $result->result_array();
            return $photos_category;
            //echo "ahmed"; exit;
        } else {
            return FALSE;
        }
    }

    function create_photos($photos_url = NULL) {


        if ($photos_url != NULL) {
            //if($photos_url != NULL){

            $uid = $this->session->userdata('id');
            $this->db->set('ph_user_id', $uid);
            $this->db->set('ph_title', $this->input->post('title'));
            $this->db->set('ph_url', $photos_url);
            $this->db->set('ph_sec_id', $this->input->post('section_id'));
            $this->db->insert('photo');
        }
        return TRUE;
    }

    function get_users($row) {
        $result = $this->db->query("SELECT 
  d_users.*,
  d_branch.*
FROM d_users
  LEFT JOIN d_branch ON d_users.user_branch_id = d_branch.branch_id
    ORDER BY user_ord ASC
      LIMIT $row,10");
        return $result->result_array();
    }

    function get_all() {
        $result = $this->db->query("SELECT 
  d_users.*,
  d_branch.*
FROM d_users
  LEFT JOIN d_branch ON d_users.user_branch_id = d_branch.branch_id
    ORDER BY user_ord ASC");
        return $result->result_array();
    }

    function search_all() {
        $user_full_name = $this->input->post('user_full_name');
        $user_email = $this->input->post('user_email');
        $user_phone = $this->input->post('user_phone');
        $user_branch_id = $this->input->post('user_branch_id');
        $conditions = array();
        if ($user_full_name !== '') {
            $conditions[] = 'user_full_name = "' . $user_full_name . '"';
        }
        if ($user_email !== '') {
            $conditions[] = 'user_email = "' . $user_email . '"';
        }

        if ($user_phone !== '') {
            $conditions[] = 'user_phone = "' . $user_phone . '"';
        }

        if ($user_branch_id !== '') {
            $conditions[] = 'user_branch_id = "' . $user_branch_id . '"';
        }


        $sqlStatement = 'SELECT
                    d_branch.*,
                    d_users.*
                  FROM  d_users
                    LEFT JOIN d_branch
                      ON d_branch.branch_id = d_users.user_branch_id WHERE ' . implode(' AND ', $conditions);
        $result = $this->db->query($sqlStatement);

        return $result->result_array();
    }

}
