<?php  if ( !defined('BASEPATH')) exit('No direct script access allowed');

class New_user extends front_end
{
    function __construct() 
    {
        $this->load->library("form_validation");
        $this->load->library('captcha/captcha');
        $this->form_validation->CI =& $this;       
        $this->load->model("new_user_model","new_user");
        //$this->load_lang('validation');
    }
    
    function index() 
    {
        
    }
    
    function create_newuser() 
    {        
        $this->session->set_userdata('cap',$this->input->post('captcha'));
        $this->set_form_rules();
        
        if ($this->form_validation->run() == FALSE) {         
            $this->view('site/users_new');
        }else{
            //$image_file = $this->upload_image('image_file_2');
            $this->new_user->create_newuser();
            $this->send_reg_email();
            $data['msg'] = "تم تسجيل عضويتك بنجاح ... انتظر رسالة من إدارة الموقع على بريدك الالكتروني تفيد تفعيل عضويتك .. شكرا";
            $this->view('theme/msg',$data);
        }
        
    }
    
    function send_reg_email()
    {
        $this->load->library("email");
        $config['protocol'] = 'mail';
        $config['charset'] = 'utf-8';
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);
        $this->email->from($this->option->get('site_email'));
        $this->email->to($this->option->get('site_email'));
        $this->email->subject("تسجيل عضو جديد بموقع أمن المعلومات");
        $this->email->message("بيانات العضو"."<br>"
                              ."name: ".$this->input->post("name")."."."<br>"
                              ."username: ".$this->input->post("username")."."."<br>"
                              ."email: ".$this->input->post("email")."."."<br>"
                              
                              );
        $this->email->send();
    }
    
    function edit_user($user_id) 
    {
        $this->set_edit_form_rules();
        
        if ($this->form_validation->run() == FALSE) {
         
            $data['user_info'] = $this->new_user->get_user_info($user_id);
            $this->view('site/users_edit',$data);
        }else{
            //$image_file = $this->upload_image();
            $this->new_user->edit_user($user_id,$image_file);
            $data['msg'] = "تم تعديل بيانات عضويتك بنجاح ... شكرا";
            $this->view('theme/msg',$data);
        }
        
    }
    
    function edit_userphoto($user_id) 
    {        
        if ($this->form_validation->run() == FALSE) {
         echo "ahmed";
            $data['user_info'] = $this->new_user->get_user_info($user_id);
            $this->view('site/users_editphoto',$data);
        }else{
            $image_file = $this->upload_image('image_file_2');
            $this->new_user->edit_userphoto($user_id,$image_file);
            $this->view('site/edit_msg');
        }
        
    }
    
    function upload_image($file) 
    {
        $upload_cfg['upload_path'] = "global/uploads";
        $upload_cfg['encrypt_name'] = TRUE;
        $upload_cfg['allowed_types'] = "gif|jpg|png|jpeg";
        $this->load->library("upload",$upload_cfg);
        
        if($this->upload->do_upload($file)){
            $image = $this->upload->data();
            return $image['file_name'];
        }else{
            return FALSE;
        }
    }
       
    function set_form_rules()
    {
        $this->form_validation->set_error_delimiters("<span class='incorrect'>","</span>");
        $this->form_validation->set_rules("username","اسم المستخدم","trim|required|min_length[4]|max_length[32]|callback_check_username|xss_clean");
        $this->form_validation->set_rules("name","الإسم","trim|required|xss_clean");       
        $this->form_validation->set_rules("password","رمز المرور","required|min_length[8]|max_length[32]|matches[passconf]|xss_clean");
        $this->form_validation->set_rules("passconf","تأكيد رمز المرور","required|xss_clean");
        $this->form_validation->set_rules("email","البريد الالكتروني","trim|required|valid_email|callback_check_email|xss_clean");                
        $this->form_validation->set_rules('captcha', 'كود الصورة', 'trim|required|xss_clean|htmlspecialchars|callback_validate_captcha');
        $this->form_validation->set_message('validate_captcha','أدخل الكود الصحيح');
    }
    
    function set_edit_form_rules()
    {
        $this->form_validation->set_error_delimiters("<span class='incorrect'>","</span>");
        $this->form_validation->set_rules("username","اسم المستخدم","trim|required|min_length[4]|max_length[32]|callback_check_username|xss_clean");
        $this->form_validation->set_rules("name","الإسم","trim|required|xss_clean");        
        $this->form_validation->set_rules("email","الإيميل","trim|required|callback_check_email|valid_email|xss_clean");                           
    }
    
    function validate_captcha()
    {
        $result = $this->captcha->validate($this->session->userdata('cap'));
        return $result;
    }
    
    function check_email()
    {
        $user_email = $this->input->post('email');
        $check_email = $this->new_user->check_email($user_email);
        if($check_email){
            if($check_email->user_username == $this->session->userdata('username')){
                return TRUE;
            }else{
                $this->form_validation->set_message('check_email','هذا الإيميل مسجل لدينا من قبل');
                return FALSE;
            }
        }else{
            return TRUE;
        }
        
    }
    
    function check_username()
    {
        $user_username = $this->input->post('username');
        $check_username = $this->new_user->check_username($user_username);
        if($check_username){
            if($check_username->user_username == $this->session->userdata('username')){
                return TRUE;
            }else{
               $this->form_validation->set_message('check_username','هذا الإسم مسجل لدينا من قبل');
                return FALSE; 
            } 
        }else{
            return TRUE;
        }
    }


}
?>