<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 *
 * NETBEANS - Code Completion Keys
 * @property CI_Loader $load
 * @property CI_Form_validation $form_validation
 * @property CI_Input $input
 * @property CI_Email $email
 * @property CI_DB_active_record $db
 * @property CI_Language $lang
 * @property users_model $users
 * @property users_setting_model $users_setting
 * @property friends_model $friends
 * @property Checker $checker
 * @property CI_Session $session
 * @property Tools $tools
 *
*/
class Forget_data extends front_end {

    function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->library('encrypt');
    }

    function index()
    {
        $this->load_forget_data_form();
    }

    function check_data()
    {
        $this->form_validation->set_error_delimiters("<span class='incorrect'>","</span>");
        $this->form_validation->set_rules('email', "البريد الالكتروني", 'trim|required|xss_clean|htmlspecialchars|valid_email|max_length[100]|callback_is_email_exist');
        if($this->form_validation->run()) {
            $user_email = $this->input->post('email');
            $userData = $this->db->query("select * from d_users where user_email = '$user_email'")->row();
            //print_r($userData);exit;
            $this->load->library("email");
            $config['protocol'] = 'mail';
            $config['charset'] = 'utf-8';
            $config['mailtype'] = 'html';
            $config['wordwrap'] = TRUE;
            $this->email->initialize($config);
            $this->email->from($this->option->get('site_email'));
            $this->email->to($this->input->post("email"));
            $this->email->subject("رمز المرور الخاص بك");
            $this->email->message("بيانات دخول الموقع"."<br>"
                                  ."email: ".$userData->user_email."."."<br>"
                                  ."password: ".base64_decode($userData->user_password)."."."<br>"
                                  );
            $this->email->send();
            $data['msg'] = "سيتم إرسال رسالة إلى بريدك الالكتروني بها كلمة السر الخاصة بك";
            $this->view('theme/msg',$data);
            //$this->finish();
        }else{
            $this->view("users/site/forget_data_form");
        }
    }

/* check if this mail found in users table or not */

    function is_email_exist($email)
    {
        $num = $this->db->query("select user_email from d_users where user_email = '$email'");
        if ($num->num_rows()) {
            return TRUE;
        } else {
            $this->form_validation->set_message("is_email_exist", "هذا الإيميل غير مسجل لدينا .. من فضلك أدخل الإيميل الصحيح");
            return FALSE;
        }
    }

    function load_forget_data_form()
    {
        $this->view('users/site/forget_data_form');
    }

    function filter_input_data()
    {
        $this->form_validation->set_rules('username', "اسم المستخدم", 'trim|required|xss_clean|htmlspecialchars|min_length[2]|max_length[50]');
        $this->form_validation->set_rules('email', "البريد الإلكترونى", 'trim|required|xss_clean|htmlspecialchars|valid_email|max_length[100]');
        $this->form_validation->set_rules('password', "كلمة السر", 'trim|required|xss_clean|htmlspecialchars|min_length[6]|min_length[6]|matches[confirm_password]|md5');
        $this->form_validation->set_rules('confirm_password', "تأكيد كلمة السر", 'trim|required|xss_clean|htmlspecialchars');
    }

    function finish()
    {
        $this->session->set_flashdata("msg",$this->lang->line("login_data_sent"));
        $this->tools->meta_refresh("site");
    }

}
