<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_users extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }
        $this->load->model('branch/branch_model');
        $this->load->model('user_model', 'user');
        $this->load->language('users/users');
        $this->load->library('form_validation');
    }

    function index() {

        $this->overview();
    }

    /**
     *  display all users in datagrid.
     */
    public function overview($row = 0) {
        $this->auth->check('manage_users', 'admin/dashboard');

        $this->load->library('pagination');
        // $this->load->view('admin/template', $data);
        $config['base_url'] = base_url() . "users/admin_users/overview";
        $config['total_rows'] = $this->user->getNumUsers();

        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);
        $data['row'] = $row;
        $data['total_rows'] = $this->user->getNumUsers();
        $data['links'] = $this->pagination->create_links();
        $data['users'] = $this->user->get_users($row);
        $this->view('users_list', $data);
    }

    function export_users_reprt() {
        $this->auth->check('print_users', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;
        $data['all_users'] = $this->user->get_all();
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('users/print_users', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        // $output = 'user_report' . date('Y_m_d_H_i_s') . '_.pdf';
        // $pdf->Output("$output", 'I'); // save to file because we can
        $pdf->Output(); // save to file because we can
        exit();
        redirect('user/admin_user');
    }

    function export_oneuser_reprt($id) {
        $this->auth->check('print_users', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['user'] = $this->user->get_user_one($id);
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('users/print_user', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        //  $output = 'user_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output(); // save to file because we can
        exit();
        redirect('user/admin_user');
    }

    // load search from
    public function user_search() {
        $this->auth->check('search_users', 'admin/dashboard');

        $this->load->model('branch/branch_model', 'branch_category');
        $data['branch_category'] = $this->branch_category->get_all_for_dropdown();
        $this->view('users/user_search', $data);
    }

    // get advanced search
    public function search_adv() {
        $this->load->model('search/search_model', 'search');
        $user_full_name = $this->input->post('user_full_name');
        $user_email = $this->input->post('user_email');
        $user_phone = $this->input->post('user_phone');
        $user_branch_id = $this->input->post('user_branch_id');
        $result1 = '';

        if ($user_full_name == NULL and $user_email == NULL and $user_phone == NULL and $user_branch_id == NULL) {
            $this->user_search();
        } else {
            $data['no_results'] = '';
            if (!$result1) {
                $data['no_results'] = TRUE;
            } else {
                $data['no_results'] = FALSE;
            }
            $data['all_users'] = $this->user->search_all();
//           echo $this->db->last_query();
//            exit;
//            print_r($data['all_users']);exit;

            $this->load->library('pdf');
            $pdf = $this->pdf->load();
            $pdf->allow_charset_conversion=true;  // Set by default to TRUE
            $pdf->charset_in='UTF-8';
            $pdf->SetDirectionality('rtl');
            $pdf->autoLangToFont = true;

            ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
            $html = $this->load->view('users/print_users', $data, true); // render the view into HTML
            //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
            // Create a stream
            // $pdf->mirrorMargins = 1;
            $pdf->WriteHTML($html); // write the HTML into the PDF
            //$output = 'user_report' . date('Y_m_d_H_i_s') . '_.pdf';
            $pdf->Output(); // save to file because we can
            exit();
            redirect('user/admin_user');
        }
    }

    /**
     *  create new new then redirect on overview.
     */
    public function create() {
        $this->check_right('add_users', 'admin/dashboard');

        $this->form_validation->set_rules('user_email', $this->lang->line('user_email'), 'trim|required|xss_clean|htmlspecialchars|valid_email|max_length[100]|is_unique[d_users.user_email]');
        $this->form_validation->set_rules('user_username', $this->lang->line('user_username'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_password', $this->lang->line('user_password'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_password2', $this->lang->line('user_password2'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_full_name', $this->lang->line('user_full_name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('user_phone', $this->lang->line('user_phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('user_branch_id', $this->lang->line('user_branch_id'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('user_group_id', $this->lang->line('user_group_id'), 'required|trim|required|xss_clean');
        $this->form_validation->set_rules('user_notice', $this->lang->line('user_notice'), 'trim|xss_clean');
        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال إسم مستخدم أخر.');
        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال بريد أخر.');
        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $data['groups'] = $this->user->get_group_dropdown();
        if ($this->form_validation->run() == false) {
            $this->view('users_new', $data);
        } else {
            $this->user->create();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('users/admin_users/overview/');
        }
    }

    /**
     * This function edit an new then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $this->check_right('edit_users', 'admin/dashboard');

        $data['user'] = $this->user->get_user_one($id);
        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $data['user_group'] = $this->user->get_user_group($id);
        $data['groups'] = $this->user->get_group_dropdown();

        $this->form_validation->set_rules('user_email', $this->lang->line('user_email'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_username', $this->lang->line('user_username'), 'required|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_password2', $this->lang->line('user_password2'), 'required||matches[user_password]trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_password', $this->lang->line('user_password'), 'required|trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('user_full_name', $this->lang->line('user_full_name'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('user_phone', $this->lang->line('user_phone'), 'required|trim|required|xss_clean');
        $this->form_validation->set_rules('user_branch_id', $this->lang->line('user_branch_id'), 'required|trim|required|xss_clean');
        $this->form_validation->set_rules('user_group_id', $this->lang->line('user_group_id'), 'required|trim|required|xss_clean');
        $this->form_validation->set_rules('user_notice', $this->lang->line('user_notice'), 'trim|xss_clean');
        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال إسم مستخدم أخر.');
        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال بريد أخر.');

        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('users_edit', $data);
        } else {

            $this->user->update($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
            redirect('users/admin_users/overview/');
        }
    }

    //==================================================================
    function operation() {
        $this->user->operation();
        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
        redirect('users/admin_users/');
    }

    function remove($id) {
        $this->check_right('remove_users', 'admin/dashboard');

        $courts = $this->user->get_users_one($id);
        if ($this->user->delete($id)) {
            //  if(file_exists(PUBPATH."global/uploads/".$courts->co_img)){ unlink(PUBPATH."global/uploads/".$courts->co_img); }
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('users/admin_users/');
        }
    }

    function activation_mail($user_email) {
        $this->load->library('email');
        $config['protocol'] = 'mail';
        $config['charset'] = 'utf-8';
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);
        $this->email->from($this->option->get('site_email'));
        $this->email->to($user_email);
        $this->email->subject('رسالة من موقع أمن المعلومات');
        $this->email->message('مرحبا بك زائرنا الكريم .. تم تفعيل عضويتك بموقع أمن المعلومات .. شكرا لك' . '<br />' . 'رابط الموقع : ' . base_url());

        if ($this->email->send()) {
            return TRUE;
        } else {
            $this->email->print_debugger();
        }
    }

}

/* End of file welcome.php */
/* Location: ./system/application/controllers/welcome.php */