<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Search extends front_end {

    var $temp;

    function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        //echo $this->input->post("keyboard");
        $this->lang->load('search/search');
        $this->template->metas('page_title', 'البحث');
    }

    function index() {
        $this->overview();
    }

    /* display all search in frontend. */

    function overview($row = 0) {
        $this->form_validation->set_rules('keyword', 'كلمة البحث', 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->run();
        $this->store_keyword();
        $data = $this->temp;
//        echo $this->input->post("keyword");exit;
        $data["key_word"] = $this->input->post("keyword");
        //print_r($data);exit;
        $this->view('search/site/results', $data);
    }

    public function search_form() {
        $this->load->library('adjacency_list');
        $this->load->model('family/area_category_model', 'area_category');
        $this->load->model('family/city_category_model', 'city_category');

        $data['dropdown'] = $this->adjacency_list->get_all_for_dropdown();
        $data['area_cat'] = $this->area_category->get_all_for_dropdown();
        $data['city_cat'] = $this->city_category->get_all_for_dropdown();

        $this->load->view('search/site/search_form', $data);
    }

    public function no_data() {
        $this->load->library('adjacency_list');
        $this->load->model('family/area_category_model', 'area_category');
        $this->load->model('family/city_category_model', 'city_category');

        $data['dropdown'] = $this->adjacency_list->get_all_for_dropdown();
        $data['area_cat'] = $this->area_category->get_all_for_dropdown();
        $data['city_cat'] = $this->city_category->get_all_for_dropdown();
        $this->view('search/site/search_form', $data);
    }

    public function search_adv($row = 0) {

        $this->load->model('search/search_model', 'search');
        $data['fa_name'] = $this->input->post('fa_name');
        $data['pt_id'] = $this->input->post('parent_id');
        $data['ar_id'] = $this->input->post('ar_id');
        $data['ct_id'] = $this->input->post('ct_id');
        $data['fa_product_desc'] = $this->input->post('fa_product_desc');
        //  echo 'if no input fields';
        if ($data['fa_name'] == NULL and $data['pt_id'] == 0 and $data['ar_id'] == NULL and $data['ct_id'] == NULL and $data['fa_product_desc'] == NULL) {
            //if it pagenation for old search then update view table
            if ($this->uri->segment(3)) {
                //    echo 'hiiiiiiii';
                $this->paginate_view($row);
            } else {
                // if no pagination and new empty search redirect
                $this->session->set_flashdata('notice_msg', 'عفوا يجب ملأ حقل واحد علي الأقل لظهور البحث');
                redirect('search/no_data/');
            }
        } else {
            // drop first - create new - paginate view
            $this->search->drop_view();
            $this->search->create_view();
            $this->paginate_view($row);
        }
    }

    function paginate_view($row) {
        // print session
        $this->load->library('pagination');
        $config['base_url'] = base_url() . "search/search/search_adv";
        $config['total_rows'] = $this->search->getNumviews();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';
        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';
        $this->pagination->initialize($config);
        $data['row'] = $row;
        $data['total_rows'] = $this->search->getNumviews();
        $data['links'] = $this->pagination->create_links();
        $data['result1'] = $this->search->search_view($row);
        $data['no_results'] = '';
        if (!$data['result1']) {
            $data['no_results'] = TRUE;
        } else {
            $data['no_results'] = FALSE;
        }
        $this->view('search/site/results', $data);
    }

    ////// search json /////////////
    public function search_adv_json() {

        $this->load->model('search/search_model', 'search');
        $data['fa_name'] = 'منال حسين';
        $data['pt_id'] = $this->input->post('parent_id');
        $data['ar_id'] = $this->input->post('ar_id');
        $data['ct_id'] = $this->input->post('ct_id');

        $data['fa_product_desc'] = $this->input->post('fa_product_desc');
        //  echo 'if no input fields';
        if ($data['fa_name'] == NULL and $data['pt_id'] == 0 and $data['ar_id'] == NULL and $data['ct_id'] == NULL and $data['fa_product_desc'] == NULL) {
            return false;
        } else {
            // drop first - create new - paginate view
            $this->search->drop_view();
            $this->search->create_view();
            $this->paginate_view_json();
        }
    }

    function paginate_view_json() {
        // print session
        $data['result1'] = $this->search->search_view_json();
        $data['no_results'] = '';
        if (!$data['result1']) {
            $data['no_results'] = TRUE;
        } else {
            $data['no_results'] = FALSE;
        }
        $jsoncode = json_encode($data);
        print_r($jsoncode);
        return $jsoncode;
    }

    function generate_results($keyword, $row = 0) {
        $this->load->model('search/search_model', 'search');
        $data['results'] = $this->search->generate_results($keyword, $row);
        $this->temp = $data;
    }

    /* display details of new */

    function show($id) {
        $data['new'] = $this->search->show_new($id);
        $count = $data['new']->ne_count_visit;
        $this->search->add_count($count, $id);
        $data['comments'] = $this->search->show_comments($id);
        $this->view('site/new', $data);
    }

    function store_keyword() {
        if ($this->input->post("keyword")) {
            $this->session->set_userdata('keyword', $this->input->post("keyword"));
        }
    }

}
