<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_search extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('search');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('search_model', 'search');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index() {
        $this->overview();
    }

    /* create family family.  */

    function create() {
        $this->load->model('search_category_model', 'search_category');
        $data['categories'] = $this->search_category->get_categories();
        if ($data['categories'] == NULL) {
            $this->session->set_flashdata('notice_msg', $this->lang->line('warning'));
            redirect('search/admin_search_category/create/');
        } else {
            $this->form_validation->set_rules('family_title', $this->lang->line('family_title'), 'trim|required|xss_clean|htmlspecialchars');
            $this->form_validation->set_rules('family_desc', $this->lang->line('family_desc'), 'trim|required|xss_clean');
            $this->form_validation->set_rules('family_topic', $this->lang->line('family_topic'), 'trim|required|xss_clean');
            //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
            $data['categories'] = $this->search->get_category();
            if ($this->form_validation->run() == false) {
                $this->view('family_new', $data);
            } else {
                $image_url = $this->upload_image('image_file');
                $this->search->create($image_url);
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('search/admin_search/overview/');
            }
        }
    }

    /* upload image */

    function upload_image($file) {
        $upload_cfg['upload_path'] = 'global/uploads/';
        $upload_cfg['encrypt_name'] = TRUE;
        $upload_cfg['allowed_types'] = 'gif|jpg|png';
        $this->upload->initialize($upload_cfg);
        if ($this->upload->do_upload($file)) {

            $image = $this->upload->data();

            return $image['file_name'];
        } else {

            return false;
        }
    }

    /* display all search in datagrid. */

    function overview() {
        $data['search'] = $this->search->get_search();
        $this->view('search/search_list', $data);
    }

    /* This function call operation function in search_model
      that's executes some operation according to choice. */

    function operation() {

        $this->search->operation();

        redirect('search/admin_search/overview');
    }

    /* This function remove family in database and delete img

      with family from uploaded folder. */

    function remove($id) {

        $family = $this->search->get_family_one($id);

        if ($this->search->delete($id)) {

            if (file_exists(PUBPATH . "global/uploads/" . $family->ne_img)) {
                unlink(PUBPATH . "global/uploads/" . $family->ne_img);
            }

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));

            redirect('search/admin_search/overview/');
        }
    }

    /* This function active family so appear in frontend. */

    function activate($id) {

        if ($this->search->is_valid_family($id)) {

            $this->search->activate($id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));

            redirect('search/admin_search/overview/');
        } else {

            redirect('search/admin_search/overview/');
        }
    }

    /* This function diactive family so disappear in frontend. */

    function deactivate($id) {

        if ($this->search->is_valid_family($id)) {

            $this->search->deactivate($id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));

            redirect('search/admin_search/overview/');
        } else {

            redirect('search/admin_search/overview/');
        }
    }

    /* This Function edit family. */

    function edit($id) {

        $data['family'] = $this->search->get_family_one($id);

        $data['categories'] = $this->search->get_category();

        $data['main_content'] = "family_edit";

        $this->form_validation->set_rules('family_title', $this->lang->line('family_title'), 'trim|required|xss_clean|htmlspecialchars');

        $this->form_validation->set_rules('family_desc', $this->lang->line('family_desc'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('family_topic', $this->lang->line('family_content'), 'trim|required|xss_clean');

        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() == false) {

            $this->load->view('admin/template', $data);
        } else {

            if (isset($_FILES['image_file'])) {



                $image_url = $this->upload_image('image_file');

                if ($image_url) {

                    if ($data['family']->ne_img != null) {

                        if (file_exists(PUBPATH . "global/uploads/" . $data['family']->ne_img)) {
                            unlink(PUBPATH . "global/uploads/" . $data['family']->ne_img);
                        }
                    }
                }
            }

            $this->search->update($id, $image_url);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));

            redirect('search/admin_search/overview/');
        }
    }

    /* This function sort search. */

    function sort($direction = 'up', $id = FALSE) {

        if ($id == FALSE) {

            redirect('search/admin_search/overview');
        } else {

            if ($this->search->is_valid_page($id)) {

                switch ($direction) {

                    case 'up':

                        $this->search->sort($direction, $id);

                        break;

                    case 'down':

                        $this->search->sort($direction, $id);

                        break;

                    default:

                        break;
                }

                redirect('search/admin_search/overview');
            } else {

                redirect('search/admin_search/overview');
            }
        }
    }

    /* display comments family */

    function comment($id) {

        $data['comments_family'] = $this->search->get_comments_search($id);

        $data['main_content'] = "search/comments_search_list";

        $this->load->view('admin/template', $data);
    }

}

/* End of file dashboard.php */

/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */