<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class videos_model extends CI_Model {

    public $video_name;

    function __construct() {

        parent::__construct();
    }

    /* This function get all videos from database */

    function get_videos_list($row) {
        $result = $this->db->query("SELECT *
                          FROM d_videos
                          ORDER BY d_videos.vi_created
                          LIMIT $row,10
                            ");
        if ($result->num_rows() > 0) {

            $videos_list = $result->result_array();

            return $videos_list;
        } else {

            return FALSE;
        }
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_videos");
        return $query->num_rows();
    }

    function is_valid_videos($vi_id) {

        $this->db->where('vi_id', $vi_id);
        $this->db->from('d_videos');

        if ($this->db->count_all_results() > 0) {

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function create_videos() {

        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;

        // parse youtube url to get id
        $url = $this->input->post('video_url');
        parse_str(parse_url($url, PHP_URL_QUERY), $my_array_of_vars);
        // Output: C4kxS1ksqtw
        $this->db->set('vi_name', $this->input->post('video_name'));
        $this->db->set('vi_url', $my_array_of_vars['v']);
        $this->db->set('vi_hide', $hide);
        $this->db->set('vi_created', time());
        $this->db->insert('d_videos');


        return TRUE;
    }

    function update_videos($vi_id) {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        // parse youtube url to get id
        $url = $this->input->post('video_url');
        parse_str(parse_url($url, PHP_URL_QUERY), $my_array_of_vars);
        // Output: C4kxS1ksqtw
        $this->db->where('vi_id', $vi_id);
        $this->db->set('vi_name', $this->input->post('video_name'));
        $this->db->set('vi_url', $my_array_of_vars['v']);
        $this->db->set('vi_hide', $hide);
        $this->db->update('d_videos');
    }

    function delete_videos($vi_id) {

        $this->db->where('vi_id', $vi_id);
        $this->db->delete('d_videos');

        return TRUE;
    }

    function get_videos($vi_id) {

        $this->db->where('vi_id', $vi_id);
        $result = $this->db->get('d_videos');
        if ($result->num_rows() > 0) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {

        if ($direction == 'up') {

            $this->db->where("vi_ord > $order_by");
            $this->db->order_by('vi_ord', 'asc');
            $this->db->limit(1, 0);
        } else {

            $this->db->where("vi_ord < $order_by");
            $this->db->order_by('vi_ord', 'desc');
            $this->db->limit(1, 0);
        }

        $result = $this->db->get('d_videos');

        if ($result->num_rows() == 1) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function sort($direction, $vi_id) {

        $page = $this->get_videos($vi_id);

        $next_page = $this->_get_next_page($direction, $page['vi_ord']);

        if (is_array($next_page)) {

            $this->db->set('vi_ord', $next_page['vi_ord']);
            $this->db->where('vi_id', $page['vi_id']);
            $this->db->update('d_videos');



            $this->db->set('vi_ord', $page['vi_ord']);
            $this->db->where('vi_id', $next_page['vi_id']);
            $this->db->update('d_videos');

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function _update_page_assoc($id) {

        $this->db->select_max('vi_ord');

        $result = $this->db->get('d_videos');

        $row = $result->row();

        $max_ord = $row->vi_ord + 1;

        $this->db->where('vi_id', $id);
        $this->db->set('vi_ord', $max_ord);
        $this->db->update('d_videos');

        return TRUE;
    }

    function activate($vi_id) {

        $this->db->set('vi_hide', '1');
        $this->db->where('vi_id', $vi_id);
        $this->db->update('d_videos');
    }
    function deactivate($vi_id) {

        $this->db->set('vi_hide', '0');
        $this->db->where('vi_id', $vi_id);
        $this->db->update('d_videos');
    }

    function activate_section($pi_id) {

        $this->db->set('vi_sec_hide', '1');
        $this->db->update('d_videos');
    }

    function deactivate_section($pi_id) {

        $this->db->set('vi_sec_hide', '0');
        $this->db->update('d_videos');
    }

    function activate_slider($vi_id) {

        $this->db->set('vi_slider', '1');
        $this->db->where('vi_id', $vi_id);
        $this->db->update('d_videos');
    }

    function deactivate_slider($vi_id) {

        $this->db->set('vi_slider', '0');
        $this->db->where('vi_id', $vi_id);
        $this->db->update('d_videos');
    }

    function operation() {

        if (!empty($_POST['check_nf'])) {

            $products = $_POST['check_nf'];

            for ($i = 0; $i <= count($products) - 1; $i++) {

                switch ($_POST['operation']) {

                    case "active":

                        $this->db->where('vi_id', $products[$i]);
                        $this->db->set('vi_hide', '1');
                        $this->db->update('d_videos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));

                        break;



                    case "inactive":

                        $this->db->where('vi_id', $products[$i]);
                        $this->db->set('vi_hide', '0');
                        $this->db->update('d_videos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));

                        break;



                    case "delete":

                        $this->db->where('vi_id', $products[$i]);
                        $result = $this->db->get('d_videos');

                        $r = $result->row();

                        if (file_exists(PUBPATH . "global/uploads/" . $r->vi_url)) {

                            unlink(PUBPATH . "global/uploads/" . $r->vi_url);
                        }

                        $this->db->where('vi_id', $products[$i]);
                        $this->db->delete('d_videos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));

                        break;
                }
            }
        }


//        if (isset($_POST['check_nf2'])) {
//
//            $products = $_POST['check_nf2'];
//
//            switch ($_POST['operation']) {
//
//                case "active":
//
//                    $this->db->set('vi_hide', '1');
//
//                    $this->db->update('d_videos');
//                    
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
//
//                    break;
//
//                case "inactive":
//
//                    $this->db->set('vi_hide', '0');
//
//                    $this->db->update('d_videos');
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
//                    
//                    break;
//
//                case "delete":
//
//                    $result = $this->db->get('d_videos');
//
//                    $r = $result->result_array();
//
//                    foreach ($r as $rm):
//
//                        if (file_exists(PUBPATH . "global/uploads/" . $rm->vi_url)) {
//
//                            unlink(PUBPATH . "global/uploads/" . $rm->vi_url);
//                        }
//
//                        $this->db->empty_table('d_videos');
//
//                    endforeach;
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
//                    
//                    break;
//            }
//        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////frontend//////////////////////////////////////////////////////////

    function albums() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_dept_videos where dp_hide = '1'");

//                                inner join d_dept_videos on d_dept_videos.dp_id = d_videos.vi_dept_videos_id and d_dept_videos.dp_hide= '1' and d_videos.vi_hide='1'
//
//                                where d_videos.vi_lang='$lang'
//
//                                AND d_dept_videos.dp_lang='$lang'
//
//                                GROUP BY d_videos.vi_dept_videos_id ");

        return $result->result_array();
    }

    function show_video($id) {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_videos

                                inner join d_dept_videos on d_dept_videos.dp_id = d_videos.vi_dept_videos_id and d_dept_videos.dp_hide= '1' and d_videos.vi_hide='1'

                                and d_videos.vi_dept_videos_id= $id 
");
    }

    function show_videos_byid($id) {


        $result = $this->db->query("SELECT * 

                                FROM d_videos

                                inner join d_patient on d_patient.pi_id = d_videos.vi_dept_videos_id 
                                   where
                                d_videos.vi_dept_videos_id= $id 
");

        return $result->result_array();
    }

    function add_count($count, $video_id) {

        $this->db->where('vi_id', $video_id);

        $this->db->set('vi_count', ($count + 1));

        $this->db->update('d_videos');
    }

    function get_videos_last() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("select * from d_videos where vi_hide='1' and vi_slider='1' order by vi_created desc limit 6");

        return $result->result_array();
    }

    function last_videos() {
        $result = $this->db->query("select * from d_videos where vi_hide='1' order by vi_created desc limit 10");
        return $result = $result->result_array();
    }

    function get_gallery_videos() {
        $result = $this->db->query("SELECT * FROM d_videos where vi_hide = '1' ");
        return $result->result_array();
    }

    function album_videos() {
        $result = $this->db->query("SELECT vi_name,vi_url 
                                FROM d_videos where vi_hide = '1'  order by vi_created");

        return $result->result_array();
    }

}
