<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class photos_model extends CI_Model {

    public $patient_id;
    public $photo_name;

    function __construct() {

        parent::__construct();
    }

    /* This function get all photos from database */

    function get_photos_list($patient_id, $row) {
        $result = $this->db->query("SELECT
                            d_photos.*,
                            d_patient.pi_id
                          FROM d_photos
                            INNER JOIN d_patient
                              ON d_photos.ph_dept_photos_id = d_patient.pi_id
                          WHERE d_photos.ph_dept_photos_id = $patient_id
                          ORDER BY d_patient.pi_created
                          LIMIT $row,10
                            ");
        if ($result->num_rows() > 0) {

            $photos_list = $result->result_array();

            return $photos_list;
        } else {

            return FALSE;
        }
    }

    function getNumUsersAdmin($patient_id) {
        $query = $this->db->query("select * from d_photos where ph_dept_photos_id =$patient_id ");
        return $query->num_rows();
    }

    function is_valid_photos($ph_id) {

        $this->db->where('ph_id', $ph_id);
        $this->db->from('d_photos');

        if ($this->db->count_all_results() > 0) {

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function create_photos($raw_name = NULL,$photo_url = NULL) {

            //if($photos_url != NULL){
            $this->db->set('ph_name', $raw_name);
            $this->db->set('ph_dept_photos_id',$this->session->userdata('patient_id'));
            $this->db->set('ph_url', $photo_url);
            $this->db->set('ph_created', time());
            $this->db->insert('d_photos');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
             return TRUE;
    }

    function update_photos($ph_id, $photos_url = NULL) {

        if ($photos_url != NULL) {

            $this->db->where('ph_id', $ph_id);
            $this->db->set('ph_name', $this->input->post('photos_name'));
            $this->db->set('ph_url', $photos_url);
            $this->db->update('d_photos');
        } else {

            $this->db->where('ph_id', $ph_id);
            $this->db->set('ph_name', $this->input->post('photos_name'));

            //$this->db->set('ph_url', 0);

            $this->db->update('d_photos');
        }



        return TRUE;
    }

    function delete_photos($ph_id) {

        $this->db->where('ph_id', $ph_id);
        $this->db->delete('d_photos');

        return TRUE;
    }
    function delete_photosbyurl($ph_url) {
        $this->db->where('ph_url', $ph_url);
        $this->db->delete('d_photos');
        return TRUE;
    }

    function get_photos($ph_id) {

        $this->db->where('ph_id', $ph_id);
        $result = $this->db->get('d_photos');



        if ($result->num_rows() > 0) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }    function get_photosbyurl($ph_url) {

        $this->db->where('ph_url', $ph_url);
        $result = $this->db->get('d_photos');



        if ($result->num_rows() > 0) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {

        if ($direction == 'up') {

            $this->db->where("ph_ord > $order_by");
            $this->db->order_by('ph_ord', 'asc');
            $this->db->limit(1, 0);
        } else {

            $this->db->where("ph_ord < $order_by");
            $this->db->order_by('ph_ord', 'desc');
            $this->db->limit(1, 0);
        }

        $result = $this->db->get('d_photos');

        if ($result->num_rows() == 1) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function sort($direction, $ph_id) {

        $page = $this->get_photos($ph_id);

        $next_page = $this->_get_next_page($direction, $page['ph_ord']);

        if (is_array($next_page)) {

            $this->db->set('ph_ord', $next_page['ph_ord']);
            $this->db->where('ph_id', $page['ph_id']);
            $this->db->update('d_photos');



            $this->db->set('ph_ord', $page['ph_ord']);
            $this->db->where('ph_id', $next_page['ph_id']);
            $this->db->update('d_photos');

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function _update_page_assoc($id) {

        $this->db->select_max('ph_ord');

        $result = $this->db->get('d_photos');

        $row = $result->row();

        $max_ord = $row->ph_ord + 1;

        $this->db->where('ph_id', $id);
        $this->db->set('ph_ord', $max_ord);
        $this->db->update('d_photos');

        return TRUE;
    }



    function operation() {

        if (!empty($_POST['check_nf'])) {

            $products = $_POST['check_nf'];

            for ($i = 0; $i <= count($products) - 1; $i++) {

                switch ($_POST['operation']) {

                    case "active":

                        $this->db->where('ph_id', $products[$i]);
                        $this->db->update('d_photos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));

                        break;



                    case "inactive":

                        $this->db->where('ph_id', $products[$i]);
                        $this->db->update('d_photos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));

                        break;



                    case "delete":

                        $this->db->where('ph_id', $products[$i]);
                        $result = $this->db->get('d_photos');

                        $r = $result->row();

                        if (file_exists(PUBPATH . "global/uploads/" . $r->ph_url)) {

                            unlink(PUBPATH . "global/uploads/" . $r->ph_url);
                        }

                        $this->db->where('ph_id', $products[$i]);
                        $this->db->delete('d_photos');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));

                        break;
                }
            }
        }

//        if (isset($_POST['check_nf2'])) {
//
//            $products = $_POST['check_nf2'];
//
//            switch ($_POST['operation']) {
//
//                case "active":
//
//                    $this->db->set('ph_hide', '1');
//
//                    $this->db->update('d_photos');
//                    
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
//
//                    break;
//
//                case "inactive":
//
//                    $this->db->set('ph_hide', '0');
//
//                    $this->db->update('d_photos');
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
//                    
//                    break;
//
//                case "delete":
//
//                    $result = $this->db->get('d_photos');
//
//                    $r = $result->result_array();
//
//                    foreach ($r as $rm):
//
//                        if (file_exists(PUBPATH . "global/uploads/" . $rm->ph_url)) {
//
//                            unlink(PUBPATH . "global/uploads/" . $rm->ph_url);
//                        }
//
//                        $this->db->empty_table('d_photos');
//
//                    endforeach;
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
//                    
//                    break;
//            }
//        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////frontend//////////////////////////////////////////////////////////

    function albums() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_dept_photos where dp_hide = '1'");

//                                inner join d_dept_photos on d_dept_photos.dp_id = d_photos.ph_dept_photos_id and d_dept_photos.dp_hide= '1' and d_photos.ph_hide='1'
//
//                                where d_photos.ph_lang='$lang'
//
//                                AND d_dept_photos.dp_lang='$lang'
//
//                                GROUP BY d_photos.ph_dept_photos_id ");

        return $result->result_array();
    }

    function show_photo($id) {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_photos

                                inner join d_dept_photos on d_dept_photos.dp_id = d_photos.ph_dept_photos_id and d_dept_photos.dp_hide= '1' and d_photos.ph_hide='1'

                                and d_photos.ph_dept_photos_id= $id 
");
    }

    function show_photos_byid($id) {


        $result = $this->db->query("SELECT * 

                                FROM d_photos

                                inner join d_patient on d_patient.pi_id = d_photos.ph_dept_photos_id 
                                   where
                                d_photos.ph_dept_photos_id= $id 
");

        return $result->result_array();
    }

    function add_count($count, $photo_id) {

        $this->db->where('ph_id', $photo_id);

        $this->db->set('ph_count', ($count + 1));

        $this->db->update('d_photos');
    }

    function get_photos_last() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("select * from d_photos where ph_hide='1' and ph_slider='1' order by ph_created desc limit 6");

        return $result->result_array();
    }

    function last_photos() {
        $result = $this->db->query("select * from d_photos where ph_hide='1' order by ph_created desc limit 10");
        return $result = $result->result_array();
    }

    function rename_photos() {
        $result = $this->db->query("SELECT * FROM d_photos INNER JOIN d_patient ON d_photos.ph_dept_photos_id = d_patient.pi_id GROUP BY pi_id ");
        return $result = $result->result_array();
    }

    function photos_box() {

        $result = $this->db->query("SELECT ph_name,ph_url FROM d_photos where ph_hide ='1'   AND ph_sec_hide = '1' ORDER BY RAND() LIMIT 0,10 ");
        if ($result->num_rows() > 0) {
            return $result->result_array();
        } else {
            return FALSE;
        }
    }

    function album_photos() {


        $result = $this->db->query("SELECT ph_name,ph_url 
                                FROM d_photos where ph_hide = '1' AND ph_sec_hide = '1' order by ph_created");

        return $result->result_array();
    }

}
