<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class files_model extends CI_Model {

    public $patient_id;
    public $file_name;

    function __construct() {

        parent::__construct();
    }

    /* This function get all files from database */

    function get_files_list($patient_id, $row) {
        $result = $this->db->query("SELECT
                            d_files.*
                          FROM d_files
                          WHERE d_files.fl_dept_files_id = $patient_id
                          ORDER BY d_files.fl_created
                          LIMIT $row,10
                            ");
        if ($result->num_rows() > 0) {

            $files_list = $result->result_array();

            return $files_list;
        } else {

            return FALSE;
        }
    }

    function getNumUsersAdmin($patient_id) {
        $query = $this->db->query("select * from d_files where fl_dept_files_id =$patient_id ");
        return $query->num_rows();
    }

    function is_valid_files($fl_id) {

        $this->db->where('fl_id', $fl_id);
        $this->db->from('d_files');

        if ($this->db->count_all_results() > 0) {

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function create_files($files_url = NULL) {

        if ($files_url != NULL) {
            //if($files_url != NULL){
            $this->db->set('fl_name', $this->input->post('files_name'));
            $this->db->set('fl_dept_files_id',$this->session->userdata('patient_id'));
            $this->db->set('fl_url', $files_url);
            $this->db->set('fl_created', time());
            $this->db->insert('d_files');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        } else {
            $this->db->set('fl_name', $this->input->post('files_name'));
            $this->db->set('fl_url', '');
            $this->db->insert('d_files');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        }
        return TRUE;
    }

    function update_files($fl_id, $files_url = NULL) {

        if ($files_url != NULL) {

            $this->db->where('fl_id', $fl_id);
            $this->db->set('fl_name', $this->input->post('files_name'));
            $this->db->set('fl_url', $files_url);
            $this->db->update('d_files');
        } else {

            $this->db->where('fl_id', $fl_id);
            $this->db->set('fl_name', $this->input->post('files_name'));

            //$this->db->set('fl_url', 0);

            $this->db->update('d_files');
        }



        return TRUE;
    }

    function delete_files($fl_id) {

        $this->db->where('fl_id', $fl_id);
        $this->db->delete('d_files');

        return TRUE;
    }

    function get_files($fl_id) {

        $this->db->where('fl_id', $fl_id);
        $result = $this->db->get('d_files');



        if ($result->num_rows() > 0) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {

        if ($direction == 'up') {

            $this->db->where("fl_ord > $order_by");
            $this->db->order_by('fl_ord', 'asc');
            $this->db->limit(1, 0);
        } else {

            $this->db->where("fl_ord < $order_by");
            $this->db->order_by('fl_ord', 'desc');
            $this->db->limit(1, 0);
        }

        $result = $this->db->get('d_files');

        if ($result->num_rows() == 1) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function sort($direction, $fl_id) {

        $page = $this->get_files($fl_id);

        $next_page = $this->_get_next_page($direction, $page['fl_ord']);

        if (is_array($next_page)) {

            $this->db->set('fl_ord', $next_page['fl_ord']);
            $this->db->where('fl_id', $page['fl_id']);
            $this->db->update('d_files');



            $this->db->set('fl_ord', $page['fl_ord']);
            $this->db->where('fl_id', $next_page['fl_id']);
            $this->db->update('d_files');

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function _update_page_assoc($id) {

        $this->db->select_max('fl_ord');

        $result = $this->db->get('d_files');

        $row = $result->row();

        $max_ord = $row->fl_ord + 1;

        $this->db->where('fl_id', $id);
        $this->db->set('fl_ord', $max_ord);
        $this->db->update('d_files');

        return TRUE;
    }



    function operation() {

        if (!empty($_POST['check_nf'])) {

            $products = $_POST['check_nf'];

            for ($i = 0; $i <= count($products) - 1; $i++) {

                switch ($_POST['operation']) {

                    case "active":

                        $this->db->where('fl_id', $products[$i]);
                        $this->db->update('d_files');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));

                        break;



                    case "inactive":

                        $this->db->where('fl_id', $products[$i]);
                        $this->db->update('d_files');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));

                        break;



                    case "delete":

                        $this->db->where('fl_id', $products[$i]);
                        $result = $this->db->get('d_files');

                        $r = $result->row();

                        if (file_exists(PUBPATH . "global/uploads/" . $r->fl_url)) {

                            unlink(PUBPATH . "global/uploads/" . $r->fl_url);
                        }

                        $this->db->where('fl_id', $products[$i]);
                        $this->db->delete('d_files');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));

                        break;
                }
            }
        }

//        if (isset($_POST['check_nf2'])) {
//
//            $products = $_POST['check_nf2'];
//
//            switch ($_POST['operation']) {
//
//                case "active":
//
//
//                    $this->db->update('d_files');
//                    
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
//
//                    break;
//
//                case "inactive":
//
//
//                    $this->db->update('d_files');
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
//                    
//                    break;
//
//                case "delete":
//
//                    $result = $this->db->get('d_files');
//
//                    $r = $result->result_array();
//
//                    foreach ($r as $rm):
//
//                        if (file_exists(PUBPATH . "global/uploads/" . $rm->fl_url)) {
//
//                            unlink(PUBPATH . "global/uploads/" . $rm->fl_url);
//                        }
//
//                        $this->db->empty_table('d_files');
//
//                    endforeach;
//
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
//                    
//                    break;
//            }
//        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////frontend//////////////////////////////////////////////////////////

    function albums() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_dept_files ");

//                                inner join d_dept_files on d_dept_files.dp_id = d_files.fl_dept_files_id and d_dept_files.dp_hide= '1' and d_files.fl_hide='1'
//
//                                where d_files.fl_lang='$lang'
//
//                                AND d_dept_files.dp_lang='$lang'
//
//                                GROUP BY d_files.fl_dept_files_id ");

        return $result->result_array();
    }

    function show_file($id) {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("SELECT * 

                                FROM d_files

                                inner join d_dept_files on d_dept_files.dp_id = d_files.fl_dept_files_id'

                                and d_files.fl_dept_files_id= $id 
");
    }

    function show_files_byid($id) {


        $result = $this->db->query("SELECT * 

                                FROM d_files

                                inner join d_patient on d_patient.pi_id = d_files.fl_dept_files_id 
                                   where
                                d_files.fl_dept_files_id= $id 
");

        return $result->result_array();
    }

    function add_count($count, $file_id) {

        $this->db->where('fl_id', $file_id);

        $this->db->set('fl_count', ($count + 1));

        $this->db->update('d_files');
    }

    function get_files_last() {

        $lang = $this->session->userdata("lang");

        $result = $this->db->query("select * from d_files where fl_slider='1' order by fl_created desc limit 6");

        return $result->result_array();
    }

    function last_files() {
        $result = $this->db->query("select * from d_files  order by fl_created desc limit 10");
        return $result = $result->result_array();
    }

    function rename_files() {
        $result = $this->db->query("SELECT * FROM d_files INNER JOIN d_patient ON d_files.fl_dept_files_id = d_patient.pi_id GROUP BY pi_id ");
        return $result = $result->result_array();
    }

    function files_box() {

        $result = $this->db->query("SELECT fl_name,fl_url FROM d_files  ORDER BY RAND() LIMIT 0,10 ");
        if ($result->num_rows() > 0) {
            return $result->result_array();
        } else {
            return FALSE;
        }
    }

    function album_files() {


        $result = $this->db->query("SELECT fl_name,fl_url 
                                FROM d_files  order by fl_created");

        return $result->result_array();
    }

}
