<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Photos extends front_end {

    function __construct() {

        parent::__construct();

        $this->load->model('photos_model', 'photos');

        $this->lang->load("patient/photos");

        $this->template->metas('page_title', $this->lang->line('page_user_title'));
    }

    function index() {

        $this->overview();
    }

    /* display all categories of photos in frontend. */

    function overview() {

        $metas = array("page_title" => $this->lang->line('page_user_title'),
            "description" => "ألبوم الصور",
            "keywords" => "ألبوم الصور");

        $this->template->metas($metas);

        $data['albums'] = $this->photos->albums();
        $this->view('site/photos', $data);
    }

    /* display details of category */

    function show($id) {

        $data['photos'] = $this->photos->show_photo($id);

        if (isset($_GET['photo'])) {

            $count = $data['photos']['ph_count'];

            $photo_id = $data['photos']['ph_id'];

            $this->photos->add_count($count, $photo_id);
        }

        $this->view('site/photos', $data);
    }

    function slider() {

        $data['photos'] = $this->photos->get_photos_last();

        $this->load->view('site/photo_slider', $data);
    }

    function last_photos() {
      //  $data['last_photos'] = $this->photos->last_photos();
        $this->load->view('site/last_photos');
    }

    /* display photos ind below box */

    function album_photos() {
        $this->load->model('videos_model', 'videos');
        $data['photos'] = $this->photos->album_photos();
        $data['videos'] = $this->videos->get_gallery_videos();
        $this->view('site/album_photos', $data);
    }

    function photos_box() {

        $data['photos_box'] = $this->photos->photos_box();
        $this->load->view('site/photos_box', $data);
    }
    function rename_photos() {

        $data['rename_photos'] = $this->photos->rename_photos();
        $this->load->view('site/rename_photos', $data);
    }

}

/* End of file dashboard.php */

/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */