<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class patient extends front_end {

    function __construct() {
        parent::__construct();
        $this->load->model('patient_model', 'patient');
        $this->lang->load("patient/patient");
//        $this->template->metas('page_title', $this->lang->line('page_user_title'));
    }

    public function index() {

        $this->overview();
    }

    /**
     * This function display all patient and row is number of patient of paging
     * @example row=5
     * @param integer $row
     */
    public function overview($pt_id, $row = 0) {
        $this->load->model('product_type_category_model', 'product_type_category');
        $this->load->library('pagination');
        $config['base_url'] = base_url() . "patient/overview/$pt_id";
        $config['total_rows'] = $this->patient->getNumbycat($pt_id);
        $data['patient_by_product'] = $this->patient->get_patient_by_product($pt_id, $row);
        $data['product_one'] = $this->product_type_category->get_category_one($pt_id);
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';
        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';
        $this->pagination->initialize($config);
        $data['row'] = $row;
        $data['total_rows'] = $this->patient->getNumbycat($pt_id);

        $data['links'] = $this->pagination->create_links();


        $this->view('site/patient_by_product', $data);
    }

    /**
     * This function display detail of patient
     * @param integer $id
     */
    public function show($id = NULL) {
        $this->load->model('photos_model', 'photos');

        if ($id != NULL) {
            $data['patient'] = $this->patient->get_patient_one($id);
            $data['photos'] = $this->photos->show_photos_byid($id);


            $metas = array("page_title" => $data['patient']->pi_name,
                "description" => $data['patient']->pi_product_desc,
                "keywords" => $data['patient']->pi_name);

            $this->template->metas($metas);

            $this->view('site/patient', $data);
        } else {
            $data['msgType'] = "error";
            $data['msg'] = "هذه الصفحة غير موجودة";
            $this->view('theme/msg', $data);
        }
    }

    /**
     * This function add comment of patient
     * @param integer  $id
     */
    public function add_comment($id) {
        $data['patient'] = $this->patient->show_patient($id);
        $data['comments'] = $this->patient->show_comments($id);
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('comment', 'التعليق', 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $data['form_error'] = "";
            $this->view('site/patient', $data);
        } else {
            $this->patient->add_comment($id);
            $this->send_email($data['patient']->pi_name);
            $data['msg'] = 'تم ارسال التعليق بنجاح';
            $this->view('theme/msg', $data);
        }
    }

    function send_email($thread) {
        $this->load->library("email");
        $config['protocol'] = 'mail';
        $config['charset'] = 'utf-8';
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);
        $this->email->from($this->option->get('site_email'));
        $this->email->to($this->option->get('site_email'));
        $this->email->subject("تعليق جديد بقسم الأسر");
        $this->email->message("البيانات" . "<br>"
                . "Thread: " . $thread . "." . "<br>"
                . "Username: " . $this->session->userdata("username") . "." . "<br>"
                . "Email: " . $this->session->userdata("uemail") . "." . "<br>"
                . "Comment: " . $this->input->post("comment") . "." . "<br>"
        );
        $this->email->send();
    }

    function random_product() {
        $data['random_product'] = $this->patient->random_product();
        $this->load->view('site/random_product', $data);
    }

    function random_patient($pt_id) {
        $data['random_patient'] = $this->patient->random_patient($pt_id);
        $this->load->view('site/random_patient', $data);
    }

    function static_product() {
        $data['static_product'] = $this->patient->static_product();
        $this->load->view('site/static_product', $data);
    }

    function slide_patient() {
        $data['slide_patient'] = $this->patient->slide_patient();

        $this->load->view('site/slide_patient', $data);
    }



}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */