<?php

class Admin_Photos extends back_end
{

    public $patient_id;
    public $photo_name;

    function __construct()
    {
        parent::__construct();
        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }
        $this->lang->load('patient/photos');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('photos_model', 'photos');
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url', 'file'));
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index($patient_id = 0)
    {

        $this->overview($patient_id);
    }

    /* This function display All photos in datagrid */

    function overview($patient_id = 0, $row = 0)
    {
        $this->load->library('pagination');
        $config['base_url'] = base_url() . "patient/admin_photos/overview/$patient_id";
        $config['total_rows'] = $this->photos->getNumUsersAdmin($patient_id);
        $config['per_page'] = '10';
        $config['uri_segment'] = 5;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';
        $this->pagination->initialize($config);
        $data['row'] = $row;
        $data['total_rows'] = $this->photos->getNumUsersAdmin($patient_id);
        $data['links'] = $this->pagination->create_links();
        $this->session->set_userdata('patient_id', $patient_id);
        $data['photos'] = $this->photos->get_photos_list($patient_id, $row);
        $this->view('photos_list', $data);
    }

    /* This function create new photos */

    function create()
    {
        $this->view('upload/upload', array('error' => ''));

    }


    public function do_upload()
    {
        $upload_path_url = base_url() . 'global/uploads/';

        $config['upload_path'] = FCPATH . 'global/uploads/';
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $config['max_size'] = '30000';
        $config['encrypt_name'] = true;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload()) {

            /*            $error = array('error' => $this->upload->display_errors());
                        $this->load->view('upload', $error);*/
            $foundFiles = array();

            $this->output
                ->set_content_type('Content-Type: application/json; charset=utf-8')
                ->set_output(json_encode(array('files' => $foundFiles)));
        } else {
            $data = $this->upload->data();

            //set the data for the json array
            $info = new StdClass;
            $info->name = $data['file_name'];
            $info->size = $data['file_size'] * 1024;
            $info->type = $data['file_type'];
            $info->url = $upload_path_url . $data['file_name'];
            $info->raw_name = $data['raw_name'];
            // I set this to original file since I did not create thumbs.  change to thumbnail directory if you do = $upload_path_url .'/thumbs' .$data['file_name']
            $info->deleteUrl = base_url() . 'patient/admin_photos/deleteImage/' . $data['file_name'];
            $info->deleteType = 'DELETE';
            $info->error = null;
            $this->photos->create_photos($info->raw_name, $info->name);
            $files[] = $info;

            //this is why we put this in the constants to pass only json data
            if (IS_AJAX) {
                echo json_encode(array("files" => $files));
                //this has to be the only data returned or you will get an error.
                //if you don't give this a json array it will give you a Empty file upload result error
                //it you set this without the if(IS_AJAX)...else... you get ERROR:TRUE (my experience anyway)
                // so that this will still work if javascript is not enabled
            } else {
                $file_data['upload_data'] = $this->upload->data();
                $this->load->view('upload/upload_success', $file_data);
            }
        }
    }
    public function deleteImage($file) {//gets the job done but you might want to add error checking and security
        $success = unlink(FCPATH . 'global/uploads/' . $file);
        $this->photos->delete_photosbyurl($file);
        //info to see if it is doing what it is supposed to
        $info = new StdClass;
        $info->sucess = $success;
        $info->path = base_url() . 'global/uploads/' . $file;
        $info->file = is_file(FCPATH . 'global/uploads/' . $file);

        if (IS_AJAX) {
            //I don't think it matters if this is set but good for error checking in the console/firebug
            echo json_encode(array($info));
        } else {
            //here you will need to decide what you want to show for a successful delete
            $file_data['delete_data'] = $file;
            $this->load->view('upload/delete_success', $file_data);
        }
    }

        /* This function remove photos. */

        function remove($ph_id)
        {

            $data['photos'] = $this->photos->get_photos($ph_id);

            if ($this->photos->delete_photos($ph_id)) {

                if ($data['photos']['ph_url'] != null && file_exists(PUBPATH . "global/uploads/" . $data['photos']['ph_url'])) {

                    unlink(PUBPATH . "global/uploads/" . $data['photos']['ph_url']);
                }

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

        /* This function edit photos. */

        function edit($ph_id)
        {

            $this->form_validation->set_rules('photos_name', $this->lang->line('photos_name'), 'trim|required|xss_clean|htmlspecialchars');


            $data['photos'] = $this->photos->get_photos($ph_id);

            $this->form_validation->set_rules('photos_name', $this->lang->line('photos_name'), 'trim|required|xss_clean|htmlspecialchars');

            if ($this->form_validation->run() == FALSE) {

                $this->view('photos_edit', $data);
            } else {

                if (isset($_FILES['photos_file'])) {

                    $photos_url = $this->upload_photos('photos_file');

                    if ($photos_url) {

                        if ($data['photos']['ph_url'] != null) {

                            if (file_exists(PUBPATH . "global/uploads/" . $data['photos']['ph_url'])) {

                                unlink(PUBPATH . "global/uploads/" . $data['photos']['ph_url']);
                            }
                        }
                    }
                }

                $this->photos->update_photos($ph_id, $photos_url);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));

                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

        /* This function sort photos for display. */

//
        function sort($direction = 'up', $ph_id = FALSE)
        {

            if ($ph_id == FALSE) {

                redirect('patient/admin_photos/overview');
            } else {

                if ($this->photos->is_valid_photos($ph_id)) {

                    switch ($direction) {

                        case 'up':

                            $this->photos->sort($direction, $ph_id);

                            break;

                        case 'down':

                            $this->photos->sort($direction, $ph_id);

                            break;

                        default:

                            break;
                    }

                    redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
                } else {

                    redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
                }
            }
        }

        /* This function call operation function in photos_model

          that's executes some operation according to choice. */

        function operation()
        {

            $this->photos->operation();
            redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
        }

        /* This function activate photos to display this photos in frontend */

        function activate($ph_id)
        {

            if ($this->photos->is_valid_photos($ph_id)) {

                $this->photos->activate($ph_id);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            } else {
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

        /* This function deactivate photos to indisplay this photos in frontend */

        function deactivate($ph_id)
        {

            if ($this->photos->is_valid_photos($ph_id)) {

                $this->photos->deactivate($ph_id);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));

                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            } else {

                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

        function activate_section($ph_id)
        {

            $this->photos->activate_section($ph_id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_sec'));
            redirect('patient/admin_patient/overview/');
        }

        /* This function deactivate photos to indisplay this photos in frontend */

        function deactivate_section($ph_id)
        {

            $this->photos->deactivate_section($ph_id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_sec'));
            redirect('patient/admin_patient/overview/');
        }

        function activate_slider($ph_id)
        {

            if ($this->photos->is_valid_photos($ph_id)) {

                $this->photos->activate_slider($ph_id);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            } else {
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

        /* This function deactivate photos to indisplay this photos in frontend */

        function deactivate_slider($ph_id)
        {

            if ($this->photos->is_valid_photos($ph_id)) {

                $this->photos->deactivate_slider($ph_id);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            } else {
                redirect('patient/admin_photos/overview/' . $this->session->userdata('patient_id'));
            }
        }

}
