<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_patient extends back_end {

    private $pagesize = 20;

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('patient/patient');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('patient_model', 'patient');
        $this->load->model('barang_model');

        $this->load->helper('rupiah');
        $this->load->model('branch/branch_model');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->overview();
    }

    // search filter
//    function index() {
//        $this->barang_model->limit = 5;
//        $this->barang_model->offset = $this->uri->segment(3);
//
//        $result['query'] = $this->barang_model->listBarang();
//        $result['numrec'] = $this->barang_model->numRec();
//
//        $this->load->view('barang_view', $result);
//    }
//
//    function search_barang() {
//        if (isset($_POST['descp_msg']) && $_POST['descp_msg'] != NULL) {
//            $vDescp = $_POST['descp_msg'];
//        } else
//            $vDescp = '';
//
//        if (isset($_POST['pageNumber']) && $_POST['pageNumber'] != NULL) {
//            $idoffset = $_POST['pageNumber'] - 1;
//        } else
//            $idoffset = 0;
//
//        $this->barang_model->limit = $this->pagesize;
//        $this->barang_model->offset = $idoffset * $this->pagesize;
//        $result['offset'] = $this->barang_model->offset;
//        $result['rec'] = $this->barang_model->numRec_page($vDescp);
//        $result['query'] = $this->barang_model->listBarang_page($vDescp);
//
//        $this->load->view('barang_view_page', $result);
//    }

    /**
     *  create patient patient then redirect on overview.
     */
    public function create() {

        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $this->form_validation->set_rules('pi_name', $this->lang->line('pi_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_father', $this->lang->line('pi_father'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_family', $this->lang->line('pi_family'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_date_reg', $this->lang->line('pi_date_reg'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_mother', $this->lang->line('pi_mother'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_passport', $this->lang->line('pi_passport'), 'trim|required|xss_clean|htmlspecialchars|is_unique[d_patient.pi_passport]');
        $this->form_validation->set_rules('pi_borndate', $this->lang->line('pi_borndate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_bornplace', $this->lang->line('pi_bornplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_gender', $this->lang->line('pi_gender'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_address', $this->lang->line('pi_turk_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_address', $this->lang->line('pi_syr_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_phone', $this->lang->line('pi_turk_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_phone', $this->lang->line('pi_syr_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_name', $this->lang->line('pi_relative_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_type', $this->lang->line('pi_relative_type'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_address', $this->lang->line('pi_relative_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_phone', $this->lang->line('pi_relative_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdesc', $this->lang->line('pi_ocurdesc'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdate', $this->lang->line('pi_ocurdate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurplace', $this->lang->line('pi_ocurplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_steps', $this->lang->line('pi_steps'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_current_sit', $this->lang->line('pi_current_sit'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance', $this->lang->line('pi_importance'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance_date', $this->lang->line('pi_importance_date'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_med_team', $this->lang->line('pi_med_team'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_guide_team', $this->lang->line('pi_guide_team'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_date', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_follow', $this->lang->line('pi_housing_follow'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_branch_id', $this->lang->line('pi_branch_id'), 'required|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_num', $this->lang->line('pi_branch_id'), 'is_unique[d_patient.pi_num]|required|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_message('is_unique', 'حقل %s مكرر');
        // $this->form_validation->set_rules('hide', "التفعيل", 'trim');
//            $data['categories'] = $this->patient->get_categories_active();
        if ($this->form_validation->run() == false) {
            $this->view('patient_new', $data);
        } else {
            $this->patient->create();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function display all patient in datagrid.
     * @example row=1
     * @param integer $row
     */
    public function overview($row = 0) {

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "patient/admin_patient/overview";
        $config['total_rows'] = $this->patient->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';
        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';
        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->patient->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();
        $data['patient'] = $this->patient->get_patient($row);
        $this->view('patient/patient_list', $data);
    }

    // load search from
    public function patient_search() {
        $this->load->model('branch/branch_model', 'branch_category');
        $data['branch_category'] = $this->branch_category->get_all_for_dropdown();
        $this->view('patient/patient_search', $data);
    }

    // get advanced search
    public function search_adv() {
        $this->load->model('search/search_model', 'search');
        $data['pi_num'] = $this->input->post('pi_num');
        $data['pi_name'] = $this->input->post('pi_name');
        $data['pi_passport'] = $this->input->post('pi_passport');
        $data['pi_date_reg'] = $this->input->post('pi_date_reg');
        $data['pi_date_reg2'] = $this->input->post('pi_date_reg2');
        $data['pi_gender'] = $this->input->post('pi_gender');
        $data['pi_importance'] = $this->input->post('pi_importance');
        $data['pi_branch_id'] = $this->input->post('pi_branch_id');
        $data['result1'] = '';

        if ($data['pi_num'] == NULL and $data['pi_name'] == NULL and $data['pi_passport'] == NULL and $data['pi_date_reg'] == NULL and $data['pi_date_reg2'] == NULL and $data['pi_branch_id'] == NULL) {
            $this->search_form();
        } else {
            $data['result1'] = $this->patient->search_all();
            $data['no_results'] = '';
            if (!$data['result1']) {
                $data['no_results'] = TRUE;
            } else {
                $data['no_results'] = FALSE;
            }
            $this->view('patient/patient_result', $data);
        }
    }

    function export_patient_reprt() {
        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->SetAutoFont(AUTOFONT_RTL);
        $pdf->SetDirectionality('rtl');

        $data['all_patients'] = $this->patient->get_all();
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('patient/print_patients', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'patient_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
        exit();
        redirect('patient/admin_patient');
    }

    public function print_branch_img($branch_id) {

        $data['branch_image'] = $this->patient->get_print_branch_img($branch_id);
        $this->load->view('patient/print_branch_img', $data);
    }

    public function print_patient($branch_id) {

        $data['patient'] = $this->patient->get_print_patient($branch_id);
        $this->load->view('patient/print_patient', $data);
        exit;
    }

    /**
     * This function call operation function in patient_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->patient->operation();
        redirect('patient/admin_patient/overview');
    }

    /**
     * This function remove patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        if ($this->patient->delete($id)) {
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     *  This function activate an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->patient->is_valid_patient($id)) {
            $this->patient->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('patient/admin_patient/overview/');
        } else {
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function deactivate an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function deactivate($id) {
        if ($this->patient->is_valid_patient($id)) {
            $this->patient->deactivate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
            redirect('patient/admin_patient/overview/');
        } else {
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function edit an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $data['patient'] = $this->patient->get_patient_one($id);
        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $this->form_validation->set_rules('pi_name', $this->lang->line('pi_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_father', $this->lang->line('pi_father'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_family', $this->lang->line('pi_family'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_date_reg', $this->lang->line('pi_date_reg'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_mother', $this->lang->line('pi_mother'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_passport', $this->lang->line('pi_passport'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_borndate', $this->lang->line('pi_borndate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_bornplace', $this->lang->line('pi_bornplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_gender', $this->lang->line('pi_gender'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_address', $this->lang->line('pi_turk_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_address', $this->lang->line('pi_syr_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_phone', $this->lang->line('pi_turk_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_phone', $this->lang->line('pi_syr_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_name', $this->lang->line('pi_relative_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_type', $this->lang->line('pi_relative_type'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_address', $this->lang->line('pi_relative_address'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_phone', $this->lang->line('pi_relative_phone'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdesc', $this->lang->line('pi_ocurdesc'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdate', $this->lang->line('pi_ocurdate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurplace', $this->lang->line('pi_ocurplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_steps', $this->lang->line('pi_steps'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_current_sit', $this->lang->line('pi_current_sit'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance', $this->lang->line('pi_importance'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance_date', $this->lang->line('pi_importance_date'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_med_team', $this->lang->line('pi_med_team'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_guide_team', $this->lang->line('pi_guide_team'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_date', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_follow', $this->lang->line('pi_housing_follow'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_num', $this->lang->line('pi_branch_id'), 'required|trim|required|xss_clean|htmlspecialchars');

        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('patient_edit', $data);
        } else {
            $this->patient->update($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function sort patient then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('patient/admin_patient/overview');
        } else {
            if ($this->patient->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->patient->sort($direction, $id);
                        break;
                    case 'down':
                        $this->patient->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('patient/admin_patient/overview');
            } else {
                redirect('patient/admin_patient/overview');
            }
        }
    }

    /**
     * This function display comments of patient
     * @example id=1
     * @param integer $id
     */
    public function comment($id) {
        $data['comments_patient'] = $this->patient->get_comments_patient($id);
        $this->view('patient/comments_patient_list', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */