<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_patient extends back_end {

    private $pagesize = 10;

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('patient/patient');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('patient_model', 'patient');
        $this->load->helper('rupiah');
        $this->load->model('branch/branch_model');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function overview() {
        $this->auth->check('manage_patient', 'admin/dashboard');
        $this->index();
    }

    // search filter
    function index() {
        $this->patient->limit = 5;
        $this->patient->offset = $this->uri->segment(3);

        $result['query'] = $this->patient->listBarang();
        $result['numrec'] = $this->patient->numRec();

        $this->view('patient_lis', $result);
    }

    function search_barang() {
        if (isset($_POST['descp_msg']) && $_POST['descp_msg'] != NULL) {
            $vDescp = $_POST['descp_msg'];
        } else
            $vDescp = '';

        if (isset($_POST['pageNumber']) && $_POST['pageNumber'] != NULL) {
            $idoffset = $_POST['pageNumber'] - 1;
        } else
            $idoffset = 0;

        $this->patient->limit = $this->pagesize;
        $this->patient->offset = $idoffset * $this->pagesize;
        $result['offset'] = $this->patient->offset;
        $result['rec'] = $this->patient->numRec_page($vDescp);
        $result['query'] = $this->patient->listBarang_page($vDescp);

        $this->load->view('patient_list_page', $result);
    }

    /**
     *  create patient patient then redirect on overview.
     */
    public function create() {

        $this->auth->check('add_patient', 'admin/dashboard');

        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $this->form_validation->set_rules('pi_name', $this->lang->line('pi_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_father', $this->lang->line('pi_father'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_family', $this->lang->line('pi_family'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_date_reg', $this->lang->line('pi_date_reg'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_mother', $this->lang->line('pi_mother'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_passport', $this->lang->line('pi_passport'), 'trim|xss_clean|htmlspecialchars|is_unique[d_patient.pi_passport]');
        $this->form_validation->set_rules('pi_borndate', $this->lang->line('pi_borndate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_bornplace', $this->lang->line('pi_bornplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_gender', $this->lang->line('pi_gender'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_address', $this->lang->line('pi_turk_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_address', $this->lang->line('pi_syr_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_phone', $this->lang->line('pi_turk_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_phone', $this->lang->line('pi_syr_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_name', $this->lang->line('pi_relative_name'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_type', $this->lang->line('pi_relative_type'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_address', $this->lang->line('pi_relative_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_phone', $this->lang->line('pi_relative_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdesc', $this->lang->line('pi_ocurdesc'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdate', $this->lang->line('pi_ocurdate'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurplace', $this->lang->line('pi_ocurplace'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_steps', $this->lang->line('pi_steps'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_current_sit', $this->lang->line('pi_current_sit'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance', $this->lang->line('pi_importance'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance_date', $this->lang->line('pi_importance_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_med_team', $this->lang->line('pi_med_team'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_guide_team', $this->lang->line('pi_guide_team'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_date', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_follow', $this->lang->line('pi_housing_follow'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_branch_id', $this->lang->line('pi_branch_id'), 'required|trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_num', $this->lang->line('pi_branch_id'), 'required|trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال  رقم أخر.');

        // $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        $data['all_patients'] = $this->patient->get_max_id();
        if ($this->form_validation->run() == false) {
            if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_patient/overview');
            }
            $this->view('patient_new', $data);
        } else {
            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->patient->create();
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('patient/admin_patient/overview/');
            } else if ($this->input->post("action") == 'حفظ وطباعة') {
                $this->patient->create();
                $id = $this->patient->get_max_id();
                redirect("patient/admin_patient/edit/$id->pi_id");
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_patient/overview');
            } else {
                $this->patient_search()->create();
                $id = $this->patient->get_max_id();
                redirect("patient/admin_patient/edit/$id->pi_id");
            }
        }
    }

    // load search from
    public function patient_search() {
        $this->auth->check('search_patient', 'admin/dashboard');
        $this->load->model('branch/branch_model', 'branch_category');
        $data['branch_category'] = $this->branch_category->get_all_for_dropdown();
        $this->view('patient/patient_search', $data);
    }

    // get advanced search
    public function search_adv() {
        $this->load->model('search/search_model', 'search');
        $pi_num = $this->input->post('pi_num');
        $pi_name = $this->input->post('pi_name');
        $pi_passport = $this->input->post('pi_passport');
        $pi_date_reg = $this->input->post('pi_date_reg');
        $pi_date_reg2 = $this->input->post('pi_date_reg2');
        $pi_gender = $this->input->post('pi_gender');
        $pi_importance = $this->input->post('pi_importance');
        $pi_branch_id = $this->input->post('pi_branch_id');
        $result1 = '';
        if ($pi_num == NULL and $pi_gender == NULL and $pi_name == NULL and $pi_passport == NULL and $pi_date_reg == NULL and $pi_date_reg2 == NULL and $pi_branch_id == NULL) {
            $this->patient_search();
        } else {
            $data['no_results'] = '';
            if (!$result1) {
                $data['no_results'] = TRUE;
            } else {
                $data['no_results'] = FALSE;
            }
            $data['all_patients'] = $this->patient->search_all();
//            echo $this->db->last_query();exit;
//            print_r($data['all_patients']);exit;

            $this->load->library('pdf');
            $pdf = $this->pdf->load();
            $pdf->allow_charset_conversion=true;  // Set by default to TRUE
            $pdf->charset_in='UTF-8';
            $pdf->SetDirectionality('rtl');
            $pdf->autoLangToFont = true;

            ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
            $html = $this->load->view('patient/print_patients', $data, true); // render the view into HTML
            //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
            // Create a stream
            // $pdf->mirrorMargins = 1;
            $pdf->WriteHTML($html); // write the HTML into the PDF
            //$output = 'patient_report' . date('Y_m_d_H_i_s') . '_.pdf';
            $pdf->Output(); // save to file because we can
            exit();
            redirect('patient/admin_patient');
        }
    }

    function export_patient_reprt() {
        $this->auth->check('print_patient', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['all_patients'] = $this->patient->get_all();
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('patient/print_patients', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        // $output = 'patient_report' . date('Y_m_d_H_i_s') . '_.pdf';
        // $pdf->Output("$output", 'I'); // save to file because we can
        $pdf->Output(); // save to file because we can
        exit();
        redirect('patient/admin_patient');
    }

    function export_onepatient_reprt($id) {
        $this->auth->check('print_patient', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['patient'] = $this->patient->get_patient_one($id);

        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('patient/print_patient', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        //  $output = 'patient_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output(); // save to file because we can
        exit();
        redirect('patient/admin_patient');
    }

    /**
     * This function call operation function in patient_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->patient->operation();
        redirect('patient/admin_patient/overview');
    }

    /**
     * This function remove patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $this->auth->check('remove_patient', 'admin/dashboard');

        $this->patient->delete($id);
        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
        redirect('patient/admin_patient/overview/');
    }

    /**
     *  This function activate an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->patient->is_valid_patient($id)) {
            $this->patient->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('patient/admin_patient/overview/');
        } else {
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function deactivate an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function deactivate($id) {
        if ($this->patient->is_valid_patient($id)) {
            $this->patient->deactivate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
            redirect('patient/admin_patient/overview/');
        } else {
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function edit an patient then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $this->auth->check('edit_patient', 'admin/dashboard');

        $data['patient'] = $this->patient->get_patient_one($id);
        $data['branch_category'] = $this->branch_model->get_all_for_dropdown();
        $this->form_validation->set_rules('pi_name', $this->lang->line('pi_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_father', $this->lang->line('pi_father'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_family', $this->lang->line('pi_family'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_date_reg', $this->lang->line('pi_date_reg'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_mother', $this->lang->line('pi_mother'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_passport', $this->lang->line('pi_passport'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_borndate', $this->lang->line('pi_borndate'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_bornplace', $this->lang->line('pi_bornplace'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_gender', $this->lang->line('pi_gender'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_address', $this->lang->line('pi_turk_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_address', $this->lang->line('pi_syr_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_turk_phone', $this->lang->line('pi_turk_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_syr_phone', $this->lang->line('pi_syr_phone'), 'trim|xss_clean|htmlspecialchars');

        $this->form_validation->set_rules('pi_relative_name', $this->lang->line('pi_relative_name'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_type', $this->lang->line('pi_relative_type'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_address', $this->lang->line('pi_relative_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_relative_phone', $this->lang->line('pi_relative_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdesc', $this->lang->line('pi_ocurdesc'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurdate', $this->lang->line('pi_ocurdate'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_ocurplace', $this->lang->line('pi_ocurplace'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_steps', $this->lang->line('pi_steps'), 'trim|xss_clean|htmlspecialchars');

        $this->form_validation->set_rules('pi_current_sit', $this->lang->line('pi_current_sit'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance', $this->lang->line('pi_importance'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_importance_date', $this->lang->line('pi_importance_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_med_team', $this->lang->line('pi_med_team'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_guide_team', $this->lang->line('pi_guide_team'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_date', $this->lang->line('pi_housing_date'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('pi_housing_follow', $this->lang->line('pi_housing_follow'), 'trim|xss_clean|htmlspecialchars');

        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            if ($this->input->post('list')) {
                redirect('patient/admin_patient/overview');
            }
            $this->view('patient_edit', $data);
        } else {
            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->patient->update($id);
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('patient/admin_patient/overview/');
            } else if ($this->input->post("action") == 'طباعة') {
                $this->export_onepatient_reprt($id);
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_patient/overview');
            } else {
                $this->patient->create();
                $id = $this->patient->get_max_id();
                redirect("patient/admin_patient/edit/$id->pi_id");
            }

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
            redirect('patient/admin_patient/overview/');
        }
    }

    /**
     * This function sort patient then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('patient/admin_patient/overview');
        } else {
            if ($this->patient->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->patient->sort($direction, $id);
                        break;
                    case 'down':
                        $this->patient->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('patient/admin_patient/overview');
            } else {
                redirect('patient/admin_patient/overview');
            }
        }
    }

    /**
     * This function display comments of patient
     * @example id=1
     * @param integer $id
     */
    public function comment($id) {
        $data['comments_patient'] = $this->patient->get_comments_patient($id);
        $this->view('patient/comments_patient_list', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */