<?php

class Admin_files extends back_end {

    public $patient_id;
    public $file_name;

    function __construct() {
        parent::__construct();
        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }
        $this->lang->load('patient/files');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('files_model', 'files');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index($patient_id = 0) {

        $this->overview($patient_id);
    }

    /* This function display All files in datagrid */

    function overview($patient_id = 0, $row = 0) {
        $this->load->library('pagination');
        $config['base_url'] = base_url() . "patient/admin_files/overview/$patient_id";
        $config['total_rows'] = $this->files->getNumUsersAdmin($patient_id);
        $config['per_page'] = '10';
        $config['uri_segment'] = 5;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';
        $this->pagination->initialize($config);
        $data['row'] = $row;
        $data['total_rows'] = $this->files->getNumUsersAdmin($patient_id);
        $data['links'] = $this->pagination->create_links();
        $this->session->set_userdata('patient_id', $patient_id);
        $data['files'] = $this->files->get_files_list($patient_id, $row);
        $this->view('files_list', $data);
    }

      /* This function create new files */

    function create() {
        $this->form_validation->set_rules('files_name', $this->lang->line('files_name'), 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == FALSE) {

            $this->view('files_new');
        } else {

            if (!empty($_FILES['files_file']['name']))
                $files_url = $this->upload_files('files_file');
            else
                $files_url = NULL;
            $patient_id = $this->session->userdata('patient_id');
            $this->files->create_files($files_url);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));

            redirect('patient/admin_files/overview/'.$this->session->userdata('patient_id'));
        }
    }

    function upload_files($file) {

        $upload_cfg['upload_path'] = 'global/uploads/';

        $upload_cfg['encrypt_name'] = TRUE;

        $upload_cfg['allowed_types'] = '*';

        $this->upload->initialize($upload_cfg);

        if ($this->upload->do_upload($file)) {

            $files = $this->upload->data();

            return $files['file_name'];
        } else {

            return false;
        }
    }
    /* This function remove files. */

    function remove($fl_id) {

        $data['files'] = $this->files->get_files($fl_id);

        if ($this->files->delete_files($fl_id)) {

            if ($data['files']['fl_url'] != null && file_exists(PUBPATH . "global/uploads/" . $data['files']['fl_url'])) {

                unlink(PUBPATH . "global/uploads/" . $data['files']['fl_url']);
            }

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

    /* This function edit files. */

    function edit($fl_id) {

        $this->form_validation->set_rules('files_name', $this->lang->line('files_name'), 'trim|required|xss_clean|htmlspecialchars');


        $data['files'] = $this->files->get_files($fl_id);

        $this->form_validation->set_rules('files_name', $this->lang->line('files_name'), 'trim|required|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() == FALSE) {

            $this->view('files_edit', $data);
        } else {

            if (isset($_FILES['files_file'])) {

                $files_url = $this->upload_files('files_file');

                if ($files_url) {

                    if ($data['files']['fl_url'] != null) {

                        if (file_exists(PUBPATH . "global/uploads/" . $data['files']['fl_url'])) {

                            unlink(PUBPATH . "global/uploads/" . $data['files']['fl_url']);
                        }
                    }
                }
            }

            $this->files->update_files($fl_id, $files_url);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));

            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

    /* This function sort files for display. */

//
    function sort($direction = 'up', $fl_id = FALSE) {

        if ($fl_id == FALSE) {

            redirect('patient/admin_files/overview');
        } else {

            if ($this->files->is_valid_files($fl_id)) {

                switch ($direction) {

                    case 'up':

                        $this->files->sort($direction, $fl_id);

                        break;

                    case 'down':

                        $this->files->sort($direction, $fl_id);

                        break;

                    default:

                        break;
                }

                redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
            } else {

                redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
            }
        }
    }

    /* This function call operation function in files_model

      that's executes some operation according to choice. */

    function operation() {

        $this->files->operation();
        redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
    }

    /* This function activate files to display this files in frontend */

    function activate($fl_id) {

        if ($this->files->is_valid_files($fl_id)) {

            $this->files->activate($fl_id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        } else {
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

    /* This function deactivate files to indisplay this files in frontend */

    function deactivate($fl_id) {

        if ($this->files->is_valid_files($fl_id)) {

            $this->files->deactivate($fl_id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));

            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        } else {

            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

    function activate_section($fl_id) {

        $this->files->activate_section($fl_id);

        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_sec'));
        redirect('patient/admin_patient/overview/');
    }

    /* This function deactivate files to indisplay this files in frontend */

    function deactivate_section($fl_id) {

        $this->files->deactivate_section($fl_id);
        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_sec'));
        redirect('patient/admin_patient/overview/');
    }

    function activate_slider($fl_id) {

        if ($this->files->is_valid_files($fl_id)) {

            $this->files->activate_slider($fl_id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        } else {
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

    /* This function deactivate files to indisplay this files in frontend */

    function deactivate_slider($fl_id) {

        if ($this->files->is_valid_files($fl_id)) {

            $this->files->deactivate_slider($fl_id);

            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        } else {
            redirect('patient/admin_files/overview/' .$this->session->userdata('patient_id'));
        }
    }

}
