<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_checkupinfo extends back_end
{

    private $pagesize = 10;

    function __construct()
    {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('patient/checkupinfo');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('checkupinfo_model', 'checkupinfo');
        $this->load->helper('rupiah');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }


    /**
     * This function display all checkupinfo in datagrid.
     * @example row=1
     * @param integer $row
     */
    public function overview()
    {

        $this->index();
    }

    // search filter
    function index()
    {
        $this->auth->check('manage_checkupinfo', 'admin/dashboard');

        $this->checkupinfo->limit = 5;
        $this->checkupinfo->offset = $this->uri->segment(3);
        $result['query'] = $this->checkupinfo->listBarang();


        $result['numrec'] = $this->checkupinfo->numRec();

        $this->view('checkinfo_list', $result);
    }

    public function filter_dylayed($row = 0)
    {
        $this->auth->check('manage_checkupinfo', 'admin/dashboard');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "branch/admin_branch/overview";
        $config['total_rows'] = $this->checkupinfo->dnumRec();

        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->checkupinfo->dnumRec();

        $data['links'] = $this->pagination->create_links();

        $data['checkupinfo'] = $this->checkupinfo->listdelyaed($row);

        $this->view('checkupinfo_delayedlist', $data);
    }

    function search_barang()
    {
        if (isset($_POST['descp_msg']) && $_POST['descp_msg'] != NULL) {
            $vDescp = $_POST['descp_msg'];
        } else
            $vDescp = '';

        if (isset($_POST['pageNumber']) && $_POST['pageNumber'] != NULL) {
            $idoffset = $_POST['pageNumber'] - 1;
        } else
            $idoffset = 0;

        $this->checkupinfo->limit = $this->pagesize;
        $this->checkupinfo->offset = $idoffset * $this->pagesize;
        $result['offset'] = $this->checkupinfo->offset;
        $result['rec'] = $this->checkupinfo->numRec_page($vDescp);
        $result['query'] = $this->checkupinfo->listBarang_page($vDescp);

        $this->load->view('checkinfo_list_page', $result);

    }


    function compareDate()
    {
        $startDate = strtotime($this->input->post('chi_date'));
        $endDate = strtotime($this->input->post('chi_nextdate'));
        if (!empty($endDate)) {
            if ($endDate >= $startDate)
                return True;
            else {
                $this->form_validation->set_message('compareDate', 'حقل تاريخ المعاينة القادمة يجب أن يكون أكبر من تاريخ المعاينة ');
                return False;
            }
        }
    }

    function notempty()
    {
        $startDate = strtotime($this->input->post('chi_date'));
        $endDate = strtotime($this->input->post('chi_nextdate'));
        if ($endDate >= $startDate)
            return True;
        else {
            $this->form_validation->set_message('compareDate', 'حقل تاريخ المعاينة القادمة يجب أن يكون أكبر من تاريخ المعاينة ');
            return False;
        }
    }

    /**
     *  create checkupinfo checkupinfo then redirect on overview.
     */
    public function create()
    {
        $this->auth->check('add_checkupinfo', 'admin/dashboard');

        $this->load->model('branch/branch_model', 'branch');
        $this->load->model('checkup/checkup_model', 'checkup');
        $this->load->model('checkup/surgery_model', 'surgery');
        $this->load->model('checkup/medicaleq_model', 'medicaleq');
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();
        $data['surgery_category'] = $this->surgery->get_all_for_dropdown();
        $data['medicaleq_category'] = $this->medicaleq->get_all_for_dropdown();
        $data['id'] = $this->checkupinfo->get_max_id();
        $data['branch_category'] = $this->branch->get_all_for_dropdown();
        $this->form_validation->set_message('typeVerify', 'يجب اختيار حركة');
        $this->form_validation->set_message('xtypeVerify', 'قم باختيار نوع معاينة قادمة او قم بإلغاء الحركة القادمة');
        $this->form_validation->set_rules('chi_pi_id', $this->lang->line('chi_pi_id'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_branch_id', $this->lang->line('chi_branch_id'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_date', $this->lang->line('chi_date'), 'trim|required|xss_clean|htmlspecialchars|callback_compareDate');
        $this->form_validation->set_rules('chi_type_id', $this->lang->line('chi_type_id'), 'trim|xss_clean||callback_typeVerify}htmlspecialchars');
        $this->form_validation->set_rules('chi_sy_id', $this->lang->line('chi_sy_id'), 'trim|callback_typeVerify|xss_clean');
        $this->form_validation->set_rules('chi_med_id', $this->lang->line('chi_med_id'), 'trim|callback_typeVerify|xss_clean');
        $this->form_validation->set_rules('chi_move_type', $this->lang->line('chi_move_type'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_nextmove', $this->lang->line('chi_nextmove'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_nextdate', $this->lang->line('chi_nextdate'), 'trim|xss_clean|callback_xtypeVerify|htmlspecialchars|callback_compareDate');
        $this->form_validation->set_rules('chi_xtype_id', $this->lang->line('chi_xtype_id'), 'trim|callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_xsy_id', $this->lang->line('chi_xsy_id'), 'trim |callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_xmed_id', $this->lang->line('chi_xmed_id'),'trim|callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_phone', $this->lang->line('chi_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_cost', $this->lang->line('chi_cost'), 'integer|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_hospital', $this->lang->line('chi_hospital'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_address', $this->lang->line('chi_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_steps', $this->lang->line('chi_steps'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_notice', $this->lang->line('chi_notice'), 'trim|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() == false) {

            if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_checkupinfo/overview');
            }
            $this->view('checkupinfo_new', $data);
        } else {

            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->checkupinfo->create();
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('patient/admin_checkupinfo/overview/');
            } else if ($this->input->post("action") == 'حفظ وطباعة') {
                $this->checkupinfo->create();
                $id = $this->checkupinfo->get_max_id();
                redirect("patient/admin_checkupinfo/edit/$id->chi_id");
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_checkupinfo/overview');
            } else {
                $this->checkupinfo->create();
                $id = $this->checkupinfo->get_max_id();
                redirect("patient/admin_checkupinfo/edit/$id->chi_id");
            }
        }
    }

    public function typeVerify()
    {
        $chi_type_id = $this->input->post('chi_type_id');
        $chi_sy_id = $this->input->post('chi_sy_id');
        $chi_med_id = $this->input->post('chi_med_id');
        if ($chi_type_id == '' AND $chi_sy_id == '' AND $chi_med_id == '') {
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function xtypeVerify()
    {

        $chi_nextmove = $this->input->post('chi_nextmove');
        $chi_xtype_id = $this->input->post('chi_xtype_id');
        $chi_xsy_id = $this->input->post('chi_xsy_id');
        $chi_xmed_id = $this->input->post('chi_xmed_id');
        $chi_nextdate = $this->input->post('chi_nextdate');
        if($chi_nextmove !== false) {
        if ( $chi_xtype_id == '' AND $chi_xsy_id == '' AND $chi_xmed_id == '' AND $chi_nextdate != '0') {
                return FALSE;
            } else {
                return TRUE;
            }
            }else{
            return true;
        }
    }

    public function autocomplete()
    {
        $pi_name = $this->input->post('pi_name');

        $query = $this->checkupinfo->get_autocomplete($pi_name);
        foreach ($query->result() as $row):
            echo "<li class='branch' id='{$row->pi_name} {$row->pi_father} {$row->pi_family}-{$row->pi_num}-{$row->pi_branch_id}-{$row->branch_name}-{$row->pi_id}'>{$row->pi_name} {$row->pi_father} {$row->pi_family}</li>";
        endforeach;
    }

    public function autocompletesearch()
    {
        $pi_name = $this->input->post('pi_name');

        $query = $this->checkupinfo->get_autocomplete($pi_name);
        foreach ($query->result() as $row):
            echo "<li class='branch' id='{$row->pi_name}</li>";
        endforeach;
    }

    // load search from
    public function checkupinfo_search()
    {
        $this->auth->check('search_checkupinfo', 'admin/dashboard');

        $this->load->model('branch/branch_model', 'branch');
        $this->load->model('checkup/checkup_model', 'checkup');
        $this->load->model('checkup/surgery_model', 'surgery');
        $this->load->model('checkup/medicaleq_model', 'medicaleq');
        $data['branch_category'] = $this->branch->get_all_for_dropdown();
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();
        $data['surgery_category'] = $this->surgery->get_all_for_dropdown();
        $data['medicaleq_category'] = $this->medicaleq->get_all_for_dropdown();
        $this->view('patient/checkupinfo_search', $data);
    }

    public function checkupdelayed_search()
    {
        $this->auth->check('search_checkupdelayed', 'admin/dashboard');
        $this->load->model('checkup/checkup_model', 'checkup');
        $this->load->model('branch/branch_model', 'branch');
        $data['branch_category'] = $this->branch->get_all_for_dropdown();
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();

        $this->view('patient/checkupdelayed_search', $data);
    }

    /**
     * This function call operation function in checkupinfo_model
     * that's executes some operation according to choice.
     */
    public function operation()
    {
        $this->checkupinfo->operation();
        redirect('patient/admin_checkupinfo/overview');
    }

    /**
     * This function remove checkupinfo then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id)
    {
        $this->auth->check('remove_checkupinfo', 'admin/dashboard');

        if ($this->checkupinfo->delete($id)) {
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect_back();
        }
    }


    public function edit($id)
    {
        $this->auth->check('edit_checkupinfo', 'admin/dashboard');
        $this->load->model('checkup/surgery_model', 'surgery');
        $this->load->model('checkup/medicaleq_model', 'medicaleq');
        $this->load->model('checkup/checkup_model', 'checkup');
        $data['checkupinfo'] = $this->checkupinfo->get_checkupinfo_one($id);
        $data['branch_category'] = $this->checkupinfo->get_one($id);
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();
        $data['surgery_category'] = $this->surgery->get_all_for_dropdown();
        $data['medicaleq_category'] = $this->medicaleq->get_all_for_dropdown();
        $this->form_validation->set_message('xtypeVerify', 'قم باختيار نوع معاينة قادمة او قم بإلغاء الحركة القادمة');

        $this->form_validation->set_rules('chi_pi_id', $this->lang->line('chi_pi_id'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_branch_id', $this->lang->line('chi_branch_id'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_date', $this->lang->line('chi_date'), 'trim|required|xss_clean|htmlspecialchars|callback_compareDate');
        $this->form_validation->set_rules('chi_type_id', $this->lang->line('chi_type_id'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_nextdate', $this->lang->line('chi_nextdate'), 'trim|callback_xtypeVerify|xss_clean|htmlspecialchars|callback_compareDate');
        $this->form_validation->set_rules('chi_nextmove', $this->lang->line('chi_nextmove'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_xtype_id', $this->lang->line('chi_xtype_id'), 'trim|callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_xsy_id', $this->lang->line('chi_xsy_id'), 'trim |callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_xmed_id', $this->lang->line('chi_xmed_id'),'trim|callback_xtypeVerify|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_phone', $this->lang->line('chi_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_cost', $this->lang->line('chi_cost'), 'integer|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_hospital', $this->lang->line('chi_hospital'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_address', $this->lang->line('chi_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_steps', $this->lang->line('chi_steps'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chi_notice', $this->lang->line('chi_notice'), 'trim|xss_clean|htmlspecialchars');
        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('checkupinfo_edit', $data);
        } else {
            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->checkupinfo->update($id);

                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
                redirect('patient/admin_checkupinfo/overview/');
            } else if ($this->input->post("action") == 'طباعة') {
                $this->export_onecheckupinfo_reprt($id);
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('patient/admin_checkupinfo/overview');
            } else {
                $this->export_onecheckupinfo_reprt($id);
            }
        }
    }

    /**
     * This function sort checkupinfo then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE)
    {
        if ($id == FALSE) {
            redirect('patient/admin_checkupinfo/overview');
        } else {
            if ($this->checkupinfo->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->checkupinfo->sort($direction, $id);
                        break;
                    case 'down':
                        $this->checkupinfo->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('patient/admin_checkupinfo/overview');
            } else {
                redirect('patient/admin_checkupinfo/overview');
            }
        }
    }

    /**
     * This function display comments of checkupinfo
     * @example id=1
     * @param integer $id
     */
    public function notify_nextcheckupinfo()
    {
        $this->load->library('session');
        $data['notify_nextcheckupinfo'] = $this->checkupinfo->notify_nextcheckupinfo();
        $this->load->view('patient/notify_nextcheckupinfo', $data);
    }

    public function unset_notify()
    {
        $this->load->library('session');
        $this->session->unset_userdata('notify');
        redirect(current_url());
    }

    // get advanced search
    public function print_notify($days)
    {
        $this->load->library('pdf');
        $this->load->library('session');
        $this->session->unset_userdata('notify');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['all_checkupinfo'] = $this->checkupinfo->print_all_notify($days);
        ini_set('memory_limit', '64M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('patient/print_checkup_alert', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'checkupinfo_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can


    }

    // get advanced search


    function export_checkupinfo_reprt()
    {
        $this->auth->check('print_checkupinfo', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;
        $this->load->model('checkup/checkup_model', 'checkup');
        $data['all_checkup'] = $this->checkup->get_all_category_byjoin();
        foreach ($data['all_checkup'] as $checkup) {
            $data['all_checkupinfo'] = $this->checkupinfo->get_bycheckup($checkup['checkup_id']);
//            exit;
            $data['row'] = $checkup['checkup_name'];
            ini_set('memory_limit', '64M'); // boost the memory limit if it's low ;)
            $pdf->AddPage();
            $html = $this->load->view('patient/print_checkupsinfo', $data, true); // render the view into HTML
            //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
            // Create a stream
            // $pdf->mirrorMargins = 1;
            $pdf->WriteHTML($html); // write the HTML into the PDF
        }

        $output = 'checkupinfo_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
    }

    // get advanced search
    public function checkupinfo_result()
    {

        $data['chi_pi_id'] = $this->input->post('chi_pi_id');
        $data['chi_cost'] = $this->input->post('chi_cost');
        $data['chi_date'] = $this->input->post('chi_date');
        $data['chi_date2'] = $this->input->post('chi_date2');
        $data['pi_name'] = $this->input->post('pi_name');
        $data['chi_type_id'] = $this->input->post('chi_type_id');
        $data['chi_branch_id'] = $this->input->post('chi_branch_id');
        $move = $this->input->post('chi_move_type');
        if ($move == 1) {
            $data['chi_move_type'] = "تقرير المعاينات";
        } elseif ($move == 2) {
            $data['chi_move_type'] = "تقرير العمليات";
        } elseif ($move == 3) {
            $data['chi_move_type'] = "تقرير التجهيزات الطبية";
        }

        $data['result1'] = '';
        if ($data['chi_pi_id'] == NULL and $data['chi_cost'] == NULL and $data['chi_date'] == NULL and $data['chi_date2'] == NULL and $data['pi_name'] == NULL and $data['chi_type_id'] == NULL and $data['chi_branch_id'] == NULL) {
            $this->checkupinfo_search();
        } else {
            $this->load->library('pdf');
            $pdf = $this->pdf->load();
            $pdf->allow_charset_conversion=true;  // Set by default to TRUE
            $pdf->charset_in='UTF-8';
            $pdf->SetDirectionality('rtl');
            $pdf->autoLangToFont = true;
            $data['all_checkupinfo'] = $this->checkupinfo->search_all();

            ini_set('memory_limit', '64M'); // boost the memory limit if it's low ;)
            $html = $this->load->view('patient/print_checkupsinfo', $data, true); // render the view into HTML
            //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
            // Create a stream

            $pdf->WriteHTML($html); // write the HTML into the PDF
            $output = 'checkupinfo_report' . date('Y_m_d_H_i_s') . '_.pdf';
            $pdf->Output("$output", 'I'); // save to file because we can

        }
    }

    function export_onecheckupinfo_reprt($id)
    {
        $this->auth->check('print_checkupinfo', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['checkupinfo'] = $this->checkupinfo->get_one($id);
        ini_set('memory_limit', '64M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('patient/print_checkupinfo', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'checkupinfo_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */
