<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class partitions_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create partition partition. */

    function create($image_url = NULL) {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        if ($image_url != NULL) {
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_desc', $this->input->post('partition_desc'));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', '');
            $this->db->set('par_hide', $hide);
            $this->db->set('par_img', $image_url);
            $this->db->set('par_created', time());
            $this->db->insert('d_partitions');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        } else {
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_desc', $this->input->post('partition_desc'));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', $this->input->post('link_img'));
            $this->db->set('par_hide', $hide);
            $this->db->set('par_img', '');
            $this->db->set('par_created', time());
            $this->db->insert('d_partitions');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        }
        return TRUE;
    }

    /*  This function get all partitions in database sort by order asc. */

    function get_partitions($row) {
        $this->db->order_by('par_ord', 'asc');
        $this->db->select('d_partitions.*');
        $this->db->limit(10, $row);
        $this->db->from('d_partitions');
        $result = $this->db->get();
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_partitions");
        return $query->num_rows();
    }

    /* This function delete partition from database. */

    function delete($id) {

        $this->db->where('par_id', $id);
        $this->db->delete('d_partitions');
        return TRUE;
    }

    function is_valid_partition($id) {
        $this->db->where('par_id', $id);
        $this->db->from('d_partitions');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('par_id', $id);
        $this->db->from('d_partitions');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_page($id) {
        $this->db->where('par_id', $id);
        $result = $this->db->get('d_partitions');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("par_ord < $order_by");
            $this->db->order_by('par_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("par_ord > $order_by");
            $this->db->order_by('par_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_partitions');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_page($id);
        $next_page = $this->_get_next_page($direction, $page['par_ord']);
        if (is_array($next_page)) {
            $this->db->set('par_ord', $next_page['par_ord']);
            $this->db->where('par_id', $page['par_id']);
            $this->db->update('d_partitions');

            $this->db->set('par_ord', $page['par_ord']);
            $this->db->where('par_id', $next_page['par_id']);
            $this->db->update('d_partitions');
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('par_ord');
        $result = $this->db->get('d_partitions');
        $row = $result->row();
        $max_ord = $row->par_ord + 1;
        $this->db->where('par_id', $id);
        $this->db->set('par_ord', $max_ord);
        $this->db->update('d_partitions');
        return TRUE;
    }

    function activate($id) {
        $this->db->set('par_hide', '1');
        $this->db->where('par_id', $id);
        $this->db->update('d_partitions');
    }

    function deactivate($id) {
        $this->db->set('par_hide', '0');
        $this->db->where('par_id', $id);
        $this->db->update('d_partitions');
    }

    function update($id, $image_url = NULL) {
        if (($this->input->post('link_img')) != Null) {
            $this->db->where('par_id', $id);
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_desc', $this->input->post('partition_desc'));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', $this->input->post('link_img'));
            $this->db->set('par_hide', $this->input->post('hide'));
            $this->db->set('par_img', '');
            $this->db->update('d_partitions');
        } else {
            $this->db->where('par_id', $id);
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_desc', $this->input->post('partition_desc'));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', $this->input->post('link_img'));
            $this->db->set('par_hide', $this->input->post('hide'));
            //if($image_url != NULL)
            //$this->db->set('par_img', $image_url);
            $this->db->update('d_partitions');
        }
        if ($image_url != NULL) {
            $this->db->where('par_id', $id);
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', '');
            $this->db->set('par_hide', $this->input->post('hide'));
            // if($image_url != NULL)
            $this->db->set('par_img', $image_url);
            $this->db->update('d_partitions');
        } else {
            $this->db->where('par_id', $id);
            $this->db->set('par_title', $this->input->post('partition_title'));
            $this->db->set('par_slug', str_replace(' ', '_', $this->input->post('partition_title')));
            $this->db->set('par_topic', $this->input->post('partition_topic'));
            $this->db->set('par_link_img', $this->input->post('link_img'));
            $this->db->set('par_hide', $this->input->post('hide'));
            $this->db->update('d_partitions');
        }
        return TRUE;
    }

    function get_partition_one($id) {
        $this->db->where('par_id', $id);
        $result = $this->db->get('d_partitions');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('par_id', $products[$i]);
                        $this->db->set('par_hide', '1');
                        $this->db->update('d_partitions');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('par_id', $products[$i]);
                        $this->db->set('par_hide', '0');
                        $this->db->update('d_partitions');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":
                        $this->db->where('par_id', $products[$i]);
                        $result = $this->db->get('d_partitions');
                        $r = $result->row();
                        if (file_exists(PUBPATH . "global/uploads/" . $r->par_img)) {
                            unlink(PUBPATH . "global/uploads/" . $r->par_img);
                        }
                        $this->db->where('par_id', $products[$i]);
                        $this->db->delete('d_partitions');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
//        if (isset($_POST['check_nf2'])) {
//            $products = $_POST['check_nf2'];
//            switch ($_POST['operation']) {
//                case "active":
//                    $this->db->set('par_hide', '1');
//                    $this->db->update('d_partitions');
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
//                    break;
//                case "inactive":
//                    $this->db->set('par_hide', '0');
//                    $this->db->update('d_partitions');
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
//                    break;
//                case "delete":
//                    $result = $this->db->get('d_partitions');
//                    $r = $result->result_array();
//                    foreach ($r as $rm):
//                        if (file_exists(PUBPATH . "global/uploads/" . $rm['par_img'])) {
//                            unlink(PUBPATH . "global/uploads/" . $rm['par_img']);
//                        }
//                        $this->db->delete('d_partitions');
//                    endforeach;
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));                    
//                    break;
//            }
//        }
    }

    function get_category() {
        $result = $this->db->get('d_partitions_category');
        return $result->result_array();
    }

    function get_comments_partitions($id) {
        $this->db->order_by('cn_ord', 'desc');
        $this->db->where('d_comments_partitions.cn_partition_id', $id);
        $this->db->select('d_partitions.*,d_comments_partitions.*');
        $this->db->from('d_comments_partitions');
        $this->db->join('d_partitions', 'd_comments_partitions.cn_partition_id=d_partitions.par_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////frontend//////////////////////////////////////////////////////////
    function get_partitions_front() {
        $lang = $this->session->userdata("lang");
        $result = $this->db->query("SELECT *
                                FROM d_partitions                                                                
                                where d_partitions.par_hide='1'
                                GROUP BY d_partitions.par_id
                                ORDER BY par_created DESC");
        return $result->result_array();
    }

    function show_partition($slug) {
        $lang = $this->session->userdata("lang");
        $result = $this->db->query("SELECT * 
                                FROM d_partitions                                
                                where d_partitions.par_hide='1'
                                and d_partitions.par_slug= '" . urldecode($slug) . "' group by d_partitions.par_id");
        return $result->row();
    }

    function add_count($count, $id) {
        $this->db->where('par_id', $id);
        $this->db->set('par_count_visit', ($count + 1));
        $this->db->update('d_partitions');
    }

    function _update_page_assoc2($id) {
        $this->db->select_max('cn_ord');
        $result = $this->db->get('d_comments_partitions');
        $row = $result->row();
        $max_ord = $row->cn_ord + 1;
        $this->db->where('cn_id', $id);
        $this->db->set('cn_ord', $max_ord);
        $this->db->update('d_comments_partitions');
        return TRUE;
    }

    function add_comment($id) {
        $this->db->set('cr_visitor_email', $this->session->userdata('uemail'));
        $this->db->set('cr_visitor_name', $this->session->userdata('username'));
        $this->db->set('cn_comment', $this->input->post('comment'));
        $this->db->set('cn_hide', 0);
        $this->db->set('cn_partition_id', $id);
        $this->db->set('cn_created', time());
        $this->db->insert('d_comments_partitions');
        $id = $this->db->insert_id();
        $this->_update_page_assoc2($id);
    }

    function show_comments($id) {
        $this->db->order_by('cn_created', 'desc');
        $this->db->where('cn_hide', 1);
        $this->db->where('cn_partition_id', $id);
        $query = $this->db->get('d_comments_partitions');
        return $query->result_array();
    }

    /////////////////////////////////paging////////////////////////////
    function getUsersWhere($field, $param) {
        $this->db->where($field, $param);
        $query = $this->db->get('d_partitions');
        // return result set as an associative array
        return $query->result_array();
    }

    // get 5 rows at a time
    function getUsers($row) {
        $this->db->order_by('par_created', 'desc');
        $this->db->where('par_hide', 1);
        $query = $this->db->get('d_partitions', 5, $row);
        if ($query->num_rows() > 0) {
            // return result set as an associative array
            return $query->result_array();
        }
    }

    // get total number of users
    function getNumUsers() {
        $query = $this->db->query("select * from d_partitions where par_hide = '1'");
        return $query->num_rows();
    }

    //////////////////////////////////end paging///////////////////

    function partitions_last() {
        $lang = $this->session->userdata("lang");
        $result = $this->db->query("select * from d_partitions where  par_hide='1' order by par_created desc limit 8");
        return $result->result_array();
    }

    function home_partitions() {
        $result = $this->db->query("select * from d_partitions where par_hide='1' order by par_created desc limit 3");
        return $result->result_array();
    }

    function fetch_partitions() {
        $result = $this->db->query("select * from d_partitions where par_hide='1' order by par_created desc");
        return $result->result_array();
    }

}