<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class partitions extends front_end {

    function __construct() {
        parent::__construct();
        $this->load->model('partitions_model', 'partitions');
        $this->lang->load("partitions/partitions");
        $this->template->metas('page_title', $this->lang->line('page_user_title'));
    }

    public function index() {
        $this->overview();
    }

    /**
     * This function display all partitions and row is number of partitions of paging
     * @example row=5
     * @param integer $row
     */
    public function overview() {
        $metas = array("page_title" => $this->lang->line('page_user_title'),
            "description" => "الأقسام",
            "keywords" => "الأقسام");

        $this->template->metas($metas);
        $data['partitions'] = $this->partitions->get_partitions_front();
        $this->view('site/partitions', $data);
    }

    /**
     * This function display detail of partition
     * @param integer $id
     */
    public function show($slug = "") {
        if ($slug != "") { 
            $data['partition'] = $this->partitions->show_partition($slug);
            
            $metas = array("page_title" => $data['partition']->par_title,
                "description" => $data['partition']->par_desc,
                "keywords" => $data['partition']->par_title);

            $this->template->metas($metas); 
            
            $count = $data['partition']->par_count_visit;
            $this->partitions->add_count($count, $data['partition']->par_id);

            $this->view('site/partition', $data);
        } else {
            $data['msgType'] = "error";
            $data['msg'] = "هذه الصفحة غير موجودة";
            $this->view('theme/msg', $data);
        }
    }

    /**
     * This function add comment of partition
     * @param integer  $id
     */
    public function add_comment($id) {
        $data['partition'] = $this->partitions->show_partition($id);
        $data['comments'] = $this->partitions->show_comments($id);
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('comment', 'التعليق', 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $data['form_error'] = "";
            $this->view('site/partition', $data);
        } else {
            $this->partitions->add_comment($id);
            $this->send_email($data['partition']->par_title);
            $data['msg'] = 'تم ارسال التعليق بنجاح';
            $this->view('theme/msg', $data);
        }
    }

    function send_email($thread) {
        $this->load->library("email");
        $config['protocol'] = 'mail';
        $config['charset'] = 'utf-8';
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);
        $this->email->from($this->option->get('site_email'));
        $this->email->to($this->option->get('site_email'));
        $this->email->subject("تعليق جديد بقسم الأقسام");
        $this->email->message("البيانات" . "<br>"
                . "Thread: " . $thread . "." . "<br>"
                . "Username: " . $this->session->userdata("username") . "." . "<br>"
                . "Email: " . $this->session->userdata("uemail") . "." . "<br>"
                . "Comment: " . $this->input->post("comment") . "." . "<br>"
        );
        $this->email->send();
    }

    function homepartitions() {
        $data['home_partitions'] = $this->partitions->home_partitions();
        $this->load->view('site/home_partitions', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */