<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_partitions extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('partitions/partitions');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('partitions_model', 'partitions');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->overview();
    }

    /**
     *  create partition partition then redirect on overview.
     */
    public function create() {

        $this->form_validation->set_rules('partition_title', $this->lang->line('partition_title'), 'is_unique[d_partitions.par_title]|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('partition_desc', $this->lang->line('partition_desc'), 'trim|required|xss_clean|max_length[200]');
        $this->form_validation->set_rules('partition_topic', $this->lang->line('partition_topic'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('hide', "التفعيل", 'trim');

        if ($this->form_validation->run() == false) {
            $this->view('partition_new');
        } else {
            $image_url = $this->upload_image('image_file');
            $this->partitions->create($image_url);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('partitions/admin_partitions/overview/');
        }
    }

    /**
     * @example image_url
     * @param file $file
     * @return file_url if true otherwise return false
     */
    public function upload_image($file) {
        $upload_cfg['upload_path'] = 'global/uploads/';
        $upload_cfg['encrypt_name'] = TRUE;
        $upload_cfg['allowed_types'] = 'gif|jpg|png';
        $this->upload->initialize($upload_cfg);
        if ($this->upload->do_upload($file)) {
            $image = $this->upload->data();
            return $image['file_name'];
        } else {
            return false;
        }
    }

    /**
     *  display all partitions in datagrid.
     */
    public function overview($row = 0) {

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "partitions/admin_partitions/overview";
        $config['total_rows'] = $this->partitions->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;
        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->partitions->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();

        $data['partitions'] = $this->partitions->get_partitions($row);
        $this->view('partitions/partitions_list', $data);
    }

    /**
     * This function call operation function in partitions_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->partitions->operation();
        redirect('partitions/admin_partitions/overview');
    }

    /**
     * This function remove partition then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $partition = $this->partitions->get_partition_one($id);
        if ($this->partitions->delete($id)) {
            if ($partition->par_img != null && file_exists(PUBPATH . "global/uploads/" . $partition->par_img)) {
                unlink(PUBPATH . "global/uploads/" . $partition->par_img);
            }
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('partitions/admin_partitions/overview/');
        }
    }

    /**
     *  This function activate an partitions then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->partitions->is_valid_partition($id)) {
            $this->partitions->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('partitions/admin_partitions/overview/');
        } else {
            redirect('partitions/admin_partitions/overview/');
        }
    }

    /**
     * This function deactivate an partitions then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function deactivate($id) {
        if ($this->partitions->is_valid_partition($id)) {
            $this->partitions->deactivate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
            redirect('partitions/admin_partitions/overview/');
        } else {
            redirect('partitions/admin_partitions/overview/');
        }
    }

    /**
     * This function edit an partition then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $data['partition'] = $this->partitions->get_partition_one($id);

        $this->form_validation->set_rules('partition_title', $this->lang->line('partition_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('partition_desc', $this->lang->line('partition_desc'), 'trim|required|xss_clean||max_length[200]');
        $this->form_validation->set_rules('partition_topic', $this->lang->line('partition_content'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        if ($this->form_validation->run() == false) {
            $this->view('partition_edit', $data);
        } else {
            if (isset($_FILES['image_file'])) {

                $image_url = $this->upload_image('image_file');
                if ($image_url) {
                    if ($data['partition']->par_img != null) {
                        if (file_exists(PUBPATH . "global/uploads/" . $data['partition']->par_img)) {
                            unlink(PUBPATH . "global/uploads/" . $data['partition']->par_img);
                        }
                    }
                }
            }
            $this->partitions->update($id, $image_url);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
            redirect('partitions/admin_partitions/overview/');
        }
    }

    /**
     * This function sort partitions then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('partitions/admin_partitions/overview');
        } else {
            if ($this->partitions->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->partitions->sort($direction, $id);
                        break;
                    case 'down':
                        $this->partitions->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('partitions/admin_partitions/overview');
            } else {
                redirect('partitions/admin_partitions/overview');
            }
        }
    }

    /**
     * This function display comments of partition
     * @example id=1
     * @param integer $id
     */
    public function comment($id) {
        $data['comments_partition'] = $this->partitions->get_comments_partitions($id);
        $this->view('partitions/comments_partitions_list', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */