<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class news_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new new. */

    function create($image_url = NULL) {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        if ($image_url != NULL) {
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_desc', $this->input->post('new_desc'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_link_img', '');
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_hide', $hide);
            $this->db->set('ne_lang', $this->input->post('lang'));
            $this->db->set('ne_img', $image_url);
            $this->db->set('ne_created', time());
            $this->db->insert('d_news');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        } else {
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_desc', $this->input->post('new_desc'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_link_img', $this->input->post('link_img'));
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_hide', $hide);
            $this->db->set('ne_img', '');
            $this->db->set('ne_lang', $this->input->post('lang'));
            $this->db->set('ne_created', time());
            $this->db->insert('d_news');
            $id = $this->db->insert_id();
            $this->_update_page_assoc($id);
        }
        return TRUE;
    }

    /*  This function get all news in database sort by order asc. */

    function get_news($row) {
        $this->db->order_by('ne_ord', 'asc');
        $this->db->select('d_news.*,d_news_category.*');
        $this->db->limit(10, $row);
        $this->db->from('d_news');
        $this->db->join('d_news_category', 'd_news_category.nc_id=d_news.ne_category_id');
        $result = $this->db->get();
        return $result->result_array();
    }
    
    
    // get total number of users
    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_news");
        return $query->num_rows();
    }
    
    function get_categories_active() {

        $this->db->where('nc_hide', '1');

        $result = $this->db->get('d_news_category');

        return $result->result_array();
    }

    /* This function delete new from database. */

    function delete($id) {       
        $this->db->where('ne_id', $id);
        $this->db->delete('d_news');
        return TRUE;
    }

    function is_valid_new($id) {
        $this->db->where('ne_id', $id);
        $this->db->from('d_news');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('ne_id', $id);
        $this->db->from('d_news');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_page($id) {
        $this->db->where('ne_id', $id);
        $result = $this->db->get('d_news');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("ne_ord < $order_by");
            $this->db->order_by('ne_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("ne_ord > $order_by");
            $this->db->order_by('ne_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_news');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_page($id);
        $next_page = $this->_get_next_page($direction, $page['ne_ord']);
        if (is_array($next_page)) {
            $this->db->set('ne_ord', $next_page['ne_ord']);
            $this->db->where('ne_id', $page['ne_id']);
            $this->db->update('d_news');

            $this->db->set('ne_ord', $page['ne_ord']);
            $this->db->where('ne_id', $next_page['ne_id']);
            $this->db->update('d_news');
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('ne_ord');
        $result = $this->db->get('d_news');
        $row = $result->row();
        $max_ord = $row->ne_ord + 1;
        $this->db->where('ne_id', $id);
        $this->db->set('ne_ord', $max_ord);
        $this->db->update('d_news');
        return TRUE;
    }

    function activate($id) {
        $this->db->set('ne_hide', '1');
        $this->db->where('ne_id', $id);
        $this->db->update('d_news');
    }

    function deactivate($id) {
        $this->db->set('ne_hide', '0');
        $this->db->where('ne_id', $id);
        $this->db->update('d_news');
    }

    function update($id, $image_url = NULL) {
        if (($this->input->post('link_img')) != Null) {
            $this->db->where('ne_id', $id);
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_desc', $this->input->post('new_desc'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_hide', $this->input->post('hide'));
            $this->db->set('ne_link_img', $this->input->post('link_img'));
            $this->db->set('ne_lang', $this->input->post('lang'));
            $this->db->set('ne_img', '');
            $this->db->update('d_news');
        } else {
            $this->db->where('ne_id', $id);
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_desc', $this->input->post('new_desc'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_link_img', $this->input->post('link_img'));
            $this->db->set('ne_lang', $this->input->post('lang'));
            $this->db->set('ne_hide', $this->input->post('hide'));
            //if($image_url != NULL)
            //$this->db->set('ne_img', $image_url);
            $this->db->update('d_news');
        }
        if ($image_url != NULL) {
            $this->db->where('ne_id', $id);
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_link_img', '');
            $this->db->set('ne_hide', $this->input->post('hide'));
            $this->db->set('ne_lang', $this->input->post('lang'));
            // if($image_url != NULL)
            $this->db->set('ne_img', $image_url);
            $this->db->update('d_news');
        } else {
            $this->db->where('ne_id', $id);
            $this->db->set('ne_new_title', $this->input->post('new_title'));
            $this->db->set('ne_new_topic', $this->input->post('new_topic'));
            $this->db->set('ne_category_id', $this->input->post('new_category'));
            $this->db->set('ne_link_img', $this->input->post('link_img'));
            $this->db->set('ne_hide', $this->input->post('hide'));
            $this->db->set('ne_lang', $this->input->post('lang'));
            // if($image_url != NULL)
            // $this->db->set('ne_img', $image_url);
            $this->db->update('d_news');
        }
        return TRUE;
    }

    function get_new_one($id) {
        $this->db->where('ne_id', $id);
        $result = $this->db->get('d_news');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('ne_id', $products[$i]);
                        $this->db->set('ne_hide', '1');
                        $this->db->update('d_news');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('ne_id', $products[$i]);
                        $this->db->set('ne_hide', '0');
                        $this->db->update('d_news');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":
                        $this->db->where('ne_id', $products[$i]);
                        $result = $this->db->get('d_news');
                        $r = $result->row();
                        if (file_exists(PUBPATH . "global/uploads/" . $r->ne_img)) {
                            unlink(PUBPATH . "global/uploads/" . $r->ne_img);
                        }
                        $this->db->where('ne_id', $products[$i]);
                        $this->db->delete('d_news');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
//        if (isset($_POST['check_nf2'])) {
//            $products = $_POST['check_nf2'];
//            switch ($_POST['operation']) {
//                case "active":
//                    $this->db->set('ne_hide', '1');
//                    $this->db->update('d_news');
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
//                    break;
//                case "inactive":
//                    $this->db->set('ne_hide', '0');
//                    $this->db->update('d_news');
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
//                    break;
//                case "delete":
//                    $result = $this->db->get('d_news');
//                    $r = $result->result_array();
//                    foreach ($r as $rm):
//                        if (file_exists(PUBPATH . "global/uploads/" . $rm['ne_img'])) {
//                            unlink(PUBPATH . "global/uploads/" . $rm['ne_img']);
//                        }
//                        $this->db->delete('d_news');
//                    endforeach;
//                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
//                    break;
//            }
//        }
    }

    function get_category() {
        $result = $this->db->get('d_news_category');
        return $result->result_array();
    }

    function get_comments_news($id) {
        $this->db->order_by('cn_ord', 'desc');
        $this->db->where('d_comments_news.cn_new_id', $id);
        $this->db->select('d_news.*,d_comments_news.*');
        $this->db->from('d_comments_news');
        $this->db->join('d_news', 'd_comments_news.cn_new_id=d_news.ne_id');
        $result = $this->db->get();
        return $result->result_array();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////frontend//////////////////////////////////////////////////////////
    function get_news_comment($row) {
        $result = $this->db->query("SELECT * , COUNT( d_comments_news.cn_new_id )
                                FROM d_news
                                left JOIN d_comments_news ON d_comments_news.cn_new_id = d_news.ne_id  and d_comments_news.cn_hide='1'
                                inner join d_news_category on d_news_category.nc_id = d_news.ne_category_id and d_news_category.nc_hide= '1'
                                where d_news.ne_hide='1'
                                GROUP BY d_news.ne_id limit $row,5");
        return $result->result_array();
    }

    function show_new($slug) {
        
        $result = $this->db->query("SELECT * 
                                FROM d_news
                                
                                inner join d_news_category on d_news_category.nc_id = d_news.ne_category_id and d_news_category.nc_hide= '1'
                                where d_news.ne_hide='1'
                                group by d_news.ne_id");
        return $result->row();
    }

    function add_count($count, $id) {
        $this->db->where('ne_id', $id);
        $this->db->set('ne_count_visit', ($count + 1));
        $this->db->update('d_news');
    }

    function _update_page_assoc2($id) {
        $this->db->select_max('cn_ord');
        $result = $this->db->get('d_comments_news');
        $row = $result->row();
        $max_ord = $row->cn_ord + 1;
        $this->db->where('cn_id', $id);
        $this->db->set('cn_ord', $max_ord);
        $this->db->update('d_comments_news');
        return TRUE;
    }

    function add_comment($id) {
        $this->db->set('cr_visitor_email', $this->session->userdata('uemail'));
        $this->db->set('cr_visitor_name', $this->session->userdata('username'));
        $this->db->set('cn_comment', $this->input->post('comment'));
        $this->db->set('cn_hide', 0);
        $this->db->set('cn_new_id', $id);
        $this->db->set('cn_created', time());
        $this->db->insert('d_comments_news');
        $id = $this->db->insert_id();
        $this->_update_page_assoc2($id);
    }

    function show_comments($id) {
        $this->db->order_by('cn_created', 'desc');
        $this->db->where('cn_hide', 1);
        $this->db->where('cn_new_id', $id);
        $query = $this->db->get('d_comments_news');
        return $query->result_array();
    }

    /////////////////////////////////paging////////////////////////////
    function getUsersWhere($field, $param) {
        $this->db->where($field, $param);
        $query = $this->db->get('d_news');
        // return result set as an associative array
        return $query->result_array();
    }

    // get 5 rows at a time
    function getUsers($row) {
        $this->db->order_by('ne_created', 'desc');
        $this->db->where('ne_hide', 1);
        $query = $this->db->get('d_news', 5, $row);
        if ($query->num_rows() > 0) {
            // return result set as an associative array
            return $query->result_array();
        }
    }

    // get total number of users
    function getNumUsers() {
        $query = $this->db->query("select * from d_news where ne_hide = '1'");
        return $query->num_rows();
    }

    //////////////////////////////////end paging///////////////////

    function news_last() {
        $lang = $this->session->userdata("lang");
        $result = $this->db->query("select * from d_news where ne_lang='$lang' and ne_hide='1' order by ne_created desc limit 8");
        return $result->result_array();
    }

    function last_news() {
        $result = $this->db->query("select * from d_news where ne_hide='1' order by ne_created desc limit 5");
        return $result->result_array();
    }

}