<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class news_category_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new category. */

    function create() {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        $this->db->set('nc_name', $this->input->post('category_name'));
        $this->db->set('nc_hide', $hide);
        $this->db->set('nc_lang', $this->input->post('lang'));
        $this->db->set('nc_created', time());
        $this->db->insert('d_news_category');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    /*  This function get all categories of news from database sort by order asc. */

    function get_categories($row) {
        $this->db->order_by('nc_ord', 'asc');
        $this->db->limit(10, $row);
        $result = $this->db->get('d_news_category');
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_news_category");
        return $query->num_rows();
    }

    /* This function delete categor of new from database. */

    function delete($id) {
        $this->db->where('ne_category_id', $id);
        $result = $this->db->get('d_news');
        $res = $result->result_array();
        foreach ($res as $r) {
            if ($r['ne_img'] != null) {
                if (file_exists(PUBPATH . "global/uploads/" . $r['ne_img'])) {
                    unlink(PUBPATH . "global/uploads/" . $r['ne_img']);
                }
            }
        }
        $this->db->where('nc_id', $id);
        $this->db->delete('d_news_category');
        $this->db->where('ne_category_id', $id);
        $this->db->delete('d_news');
        return TRUE;
    }

    function is_valid_category($id) {
        $this->db->where('nc_id', $id);
        $this->db->from('d_news_category');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('nc_id', $id);
        $this->db->from('d_news_category');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_category($id) {
        $this->db->where('nc_id', $id);
        $result = $this->db->get('d_news_category');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("nc_ord < $order_by");
            $this->db->order_by('nc_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("nc_ord > $order_by");
            $this->db->order_by('nc_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_news_category');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_category($id);
        $next_page = $this->_get_next_page($direction, $page['nc_ord']);
        if (is_array($next_page)) {
            $this->db->set('nc_ord', $next_page['nc_ord']);
            $this->db->where('nc_id', $page['nc_id']);
            $this->db->update('d_news_category');

            $this->db->set('nc_ord', $page['nc_ord']);
            $this->db->where('nc_id', $next_page['nc_id']);
            $this->db->update('d_news_category');

            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('nc_ord');
        $result = $this->db->get('d_news_category');
        $row = $result->row();
        $max_ord = $row->nc_ord + 1;
        $this->db->where('nc_id', $id);
        $this->db->set('nc_ord', $max_ord);
        $this->db->update('d_news_category');
        return TRUE;
    }

    function activate($id) {
        $this->db->set('nc_hide', '1');
        $this->db->where('nc_id', $id);
        $this->db->update('d_news_category');
        $this->db->query("update d_news set `ne_hide` = '1' where `ne_category_id` = '$id'");
    }

    function deactivate($id) {
        $this->db->set('nc_hide', '0');
        $this->db->where('nc_id', $id);
        $this->db->update('d_news_category');
        $this->db->query("update d_news set `ne_hide` = '0' where `ne_category_id` = '$id'");
    }

    function update($id) {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;

        $this->db->where('nc_id', $id);
        $this->db->set('nc_lang', $this->input->post('lang'));
        $this->db->set('nc_name', $this->input->post('category_name'));
        $this->db->set('nc_hide', $hide);
        $this->db->update('d_news_category');
        return TRUE;
    }

    function get_category_one($id) {
        $this->db->where('nc_id', $id);
        $result = $this->db->get('d_news_category');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('nc_id', $products[$i]);
                        $this->db->set('nc_hide', '1');
                        $this->db->update('d_news_category');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('nc_id', $products[$i]);
                        $this->db->set('nc_hide', '0');
                        $this->db->update('d_news_category');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":

                        $this->db->where('nc_id', $products[$i]);
                        $this->db->delete('d_news_category');
                        $this->db->where('ne_category_id', $products[$i]);
                        $this->db->delete('d_news');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('nc_hide', '1');
                    $this->db->update('d_news');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                    break;
                case "inactive":
                    $this->db->set('nc_hide', '0');
                    $this->db->update('d_news');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                    break;
                case "delete":
                    $this->db->empty_table('d_news');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                    break;
            }
        }
    }

}