<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class comments_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
/*  This function get all comments in database sort by order asc.*/
    function get_comments()
    {
       $this->db->order_by('cn_ord', 'desc');
       $this->db->select('d_news.*,d_comments_news.*');
       $this->db->from('d_comments_news');
       $this->db->join('d_news','d_news.ne_id=d_comments_news.cn_new_id');
       $result=$this->db->get();
       return $result->result_array();
    }
    /* This function delete new from database. */
    function delete($id)
    {
       $this->db->where('cn_id', $id);
       $this->db->delete('d_comments_news');
       return TRUE;
    }
    function is_valid_comment($id)
    {
        $this->db->where('cn_id', $id);
        $this->db->from('d_comments_news');
        if($this->db->count_all_results() > 0)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    function is_valid_page($id)
    {
        $this->db->where('cn_id', $id);
        $this->db->from('d_comments_news');
        if($this->db->count_all_results() > 0)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    function get_page($id)
    {
            $this->db->where('cn_id', $id);
            $result = $this->db->get('d_comments_news');
            if($result->num_rows() > 0)
            {
                    return $result->row_array();
            }
            else
            {
                    return FALSE;
            }
    }
    function _get_next_page($direction, $order_by)
    {
        if($direction == 'up')
        {
            $this->db->where("cn_ord > $order_by");
            $this->db->order_by('cn_ord', 'asc');
            $this->db->limit(1, 0);
        }
        else
        {
            $this->db->where("cn_ord < $order_by");
            $this->db->order_by('cn_ord', 'desc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_comments_news');
        if($result->num_rows() == 1)
        {
            return $result->row_array();
        }
        else
        {
            return FALSE;
        }
    }
    function sort($direction, $id)
    {
        $page = $this->get_page($id);
        $next_page = $this->_get_next_page($direction, $page['cn_ord']);
        if(is_array($next_page))
        {
            $this->db->set('cn_ord', $next_page['cn_ord']);
            $this->db->where('cn_id', $page['cn_id']);
            $this->db->update('d_comments_news');

            $this->db->set('cn_ord', $page['cn_ord']);
            $this->db->where('cn_id', $next_page['cn_id']);
            $this->db->update('d_comments_news');
            return TRUE;
        }
        else
        {
            return FALSE;
        }
    }
    function _update_page_assoc($id)
    {
            $this->db->select_max('cn_ord');
            $result = $this->db->get('d_comments_news');
            $row = $result->row();
            $max_ord = $row->cn_ord + 1;
            $this->db->where('cn_id', $id);
            $this->db->set('cn_ord', $max_ord);
            $this->db->update('d_comments_news');
            return TRUE;
    }
    function activate($id)
    {	
        $this->db->set('cn_hide', '1');
        $this->db->where('cn_id', $id);
        $this->db->update('d_comments_news');
    }
    function deactivate($id)
    {
        $this->db->set('cn_hide', '0');
        $this->db->where('cn_id', $id);
        $this->db->update('d_comments_news');
    }
    function get_comment_one($id)
    {
       $this->db->where('cn_id',$id);
       $result=$this->db->get('d_comments_news');
       return $result->row();
    }
    function operation()
    {
    if(!empty($_POST['check_nf']))
     {
        $products = $_POST['check_nf'];
        for($i = 0; $i <= count($products)-1; $i++)
         {
            switch($_POST['operation'])
           {
              case "active":
                              $this->db->where('cn_id', $products[$i]);
                              $this->db->set('cn_hide', '1');
                              $this->db->update('d_comments_news');
                              break;

              case "inactive":
                              $this->db->where('cn_id', $products[$i]);
                              $this->db->set('cn_hide', '0');
                              $this->db->update('d_comments_news');
                              break;

              case "delete":
                              $this->db->where('cn_id', $products[$i]);
                              $this->db->delete('d_comments_news');
                              break;
          }
        }
     }
     if(isset($_POST['check_nf2']))
     {
        $products = $_POST['check_nf2'];      
        switch($_POST['operation'])
         {
          case "active":
                              $this->db->set('cn_hide', '1');
                              $this->db->update('d_comments_news');
                              break;
          case "inactive":
                              $this->db->set('cn_hide', '0');
                              $this->db->update('d_comments_news');
                              break;
          case "delete":
                              $this->db->empty_table('d_comments_news');
                              break;
         }
     }
 }
}