<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class News extends front_end {

    function __construct() {
        parent::__construct();
        $this->load->model('news_model', 'news');
        $this->lang->load("news/news");
//        $this->template->metas('page_title', $this->lang->line('page_user_title'));
    }

    public function index() {

        $this->overview();
    }

    /**
     * This function display all news and row is number of news of paging
     * @example row=5
     * @param integer $row
     */
    public function overview($row = 0) {
        $metas = array("page_title" => $this->lang->line('page_user_title'),
            "description" => "الأخبار",
            "keywords" => "الأخبار");

        $this->template->metas($metas);

        $this->load->library('pagination');


        $config['base_url'] = base_url() . "news/overview";
        $config['total_rows'] = $this->news->getNumUsers();
        $config['per_page'] = '5';

        $config['full_tag_open'] = '<div class="pages">';

        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';

        $config['cur_tag_close'] = '</a>';


        $this->pagination->initialize($config);
        $data['news'] = $this->news->get_news_comment($row);
        $data['row'] = $row;
        $data['total_rows'] = $this->news->getNumUsers();
        $data['links'] = $this->pagination->create_links();

        $this->view('site/news', $data);
    }

    /**
     * This function display detail of new
     * @param integer $id
     */
    public function show($slug = "") {

        if ($slug != "") {
            $data['new'] = $this->news->show_new($slug);


            $metas = array("page_title" => $data['new']->ne_new_title,
                "description" => $data['new']->ne_new_desc,
                "keywords" => $data['new']->ne_new_title);

            $this->template->metas($metas); 

            $count = $data['new']->ne_count_visit;
            $this->news->add_count($count, $data['new']->ne_id);
            $this->view('site/new', $data);
        } else {
            $data['msgType'] = "error";
            $data['msg'] = "هذه الصفحة غير موجودة";
            $this->view('theme/msg', $data);
        }
    }

    /**
     * This function add comment of new
     * @param integer  $id
     */
    public function add_comment($id) {
        $data['new'] = $this->news->show_new($id);
        $data['comments'] = $this->news->show_comments($id);
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('comment', 'التعليق', 'trim|required|xss_clean');
        if ($this->form_validation->run() == false) {
            $data['form_error'] = "";
            $this->view('site/new', $data);
        } else {
            $this->news->add_comment($id);
            $this->send_email($data['new']->ne_new_title);
            $data['msg'] = 'تم ارسال التعليق بنجاح';
            $this->view('theme/msg', $data);
        }
    }

    function send_email($thread) {
        $this->load->library("email");
        $config['protocol'] = 'mail';
        $config['charset'] = 'utf-8';
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);
        $this->email->from($this->option->get('site_email'));
        $this->email->to($this->option->get('site_email'));
        $this->email->subject("تعليق جديد بقسم الأخبار");
        $this->email->message("البيانات" . "<br>"
                . "Thread: " . $thread . "." . "<br>"
                . "Username: " . $this->session->userdata("username") . "." . "<br>"
                . "Email: " . $this->session->userdata("uemail") . "." . "<br>"
                . "Comment: " . $this->input->post("comment") . "." . "<br>"
        );
        $this->email->send();
    }

    function last_news() {
        $data['last_news'] = $this->news->last_news();
        $this->load->view('site/last_news', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */