<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_News_category extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('news/news');
        $this->template->metas('page_title', $this->lang->line('page_title_cat'));
        $this->load->model('news_category_model', 'news_category');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->overview();
    }

    /**
     *  create new new_category then redirect overview.
     */
    public function create() {
        $this->form_validation->set_rules('category_name', $this->lang->line('category_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        
        if ($this->form_validation->run() == false) {
            $this->view('news_category_new');
        } else {
            $this->news_category->create();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('news/admin_news_category/overview/');
        }
    }

    /**
     *  display all categories of news in datagrid.
     */
    public function overview($row = 0) {
        
        $this->load->library('pagination');
        
        $config['base_url'] = base_url() . "news/admin_news/overview";
        $config['total_rows'] = $this->news_category->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';
        
        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);
        
        $data['row'] = $row;
        $data['total_rows'] = $this->news_category->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();
        
        $data['categories'] = $this->news_category->get_categories($row);
        $this->view('new_category_list', $data);
    }

    /**
     *  This function call operation function in news_category_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->news_category->operation();
        redirect('news/admin_news_category/overview');
    }

    /**
     * This function remove new_category then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $new = $this->news_category->get_category_one($id);
        if ($this->news_category->delete($id)) {
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('news/admin_news_category/overview/');
        }
    }

    /**
     *  This function activate an new_category then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->news_category->is_valid_category($id)) {
            $this->news_category->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_cat'));
            redirect('news/admin_news_category/overview/');
        } else {
            redirect('news/admin_news_category/overview/');
        }
    }

    /**
     * This function deactivate an new_category then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function deactivate($id) {
        if ($this->news_category->is_valid_category($id)) {
            $this->news_category->deactivate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_cat'));
            redirect('news/admin_news_category/overview/');
        } else {
            redirect('news/admin_news_category/overview/');
        }
    }

    /**
     * This function edit an new_category then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $data['category'] = $this->news_category->get_category_one($id);
        $this->form_validation->set_rules('category_name', $this->lang->line('category_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('news_category_edit', $data);
        } else {
            $this->news_category->update($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit_cat'));
            redirect('news/admin_news_category/overview/');
        }
    }

    /**
     * This function sort news_category then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('news/admin_news_category/overview/');
        } else {
            if ($this->news_category->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->news_category->sort($direction, $id);
                        break;
                    case 'down':
                        $this->news_category->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('news/admin_news_category/overview/');
            } else {
                redirect('news/admin_news_category/overview/');
            }
        }
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */