<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_News extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('news/news');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('news_model', 'news');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->overview();
    }

    /**
     *  create new new then redirect on overview.
     */
    public function create() {

        $data['categories'] = $this->news->get_categories_active();
        if ($data['categories'] == NULL) {
            $this->session->set_flashdata('notice_msg', $this->lang->line('warning'));
            redirect('news/admin_news_category/create/');
        } else {
            $this->form_validation->set_rules('new_title', $this->lang->line('new_title'), 'is_unique[d_news.ne_new_title]|trim|required|xss_clean|htmlspecialchars');
            $this->form_validation->set_rules('new_desc', $this->lang->line('new_desc'), 'trim|required|xss_clean');
            $this->form_validation->set_rules('new_topic', $this->lang->line('new_topic'), 'trim|required|xss_clean');
            $this->form_validation->set_rules('hide', "التفعيل", 'trim');
            $this->form_validation->set_rules('new_category', "القسم", 'trim');
//            $data['categories'] = $this->news->get_categories_active();
            if ($this->form_validation->run() == false) {
                $this->view('new_new', $data);
            } else {
                $image_url = $this->upload_image('image_file');
                $this->news->create($image_url);
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('news/admin_news/overview/');
            }
        }
    }

    /**
     * @example image_url
     * @param file $file
     * @return file_url if true otherwise return false
     */
    public function upload_image($file) {
        $upload_cfg['upload_path'] = 'global/uploads/';
        $upload_cfg['encrypt_name'] = TRUE;
        $upload_cfg['allowed_types'] = 'gif|jpg|png';
        $this->upload->initialize($upload_cfg);
        if ($this->upload->do_upload($file)) {
            $image = $this->upload->data();
            return $image['file_name'];
        } else {
            return false;
        }
    }

    /**
     *  display all news in datagrid.
     */
    public function overview($row = 0) {

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "news/admin_news/overview";
        $config['total_rows'] = $this->news->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';


        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->news->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();

        $data['news'] = $this->news->get_news($row);
        $this->view('news/news_list', $data);
    }

    /**
     * This function call operation function in news_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->news->operation();
        redirect('news/admin_news/overview');
    }

    /**
     * This function remove new then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $new = $this->news->get_new_one($id);
        if ($this->news->delete($id)) {
            if ($new->ne_img != null && file_exists(PUBPATH . "global/uploads/" . $new->ne_img)) {
                unlink(PUBPATH . "global/uploads/" . $new->ne_img);
            }
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('news/admin_news/overview/');
        }
    }

    /**
     *  This function activate an news then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->news->is_valid_new($id)) {
            $this->news->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
            redirect('news/admin_news/overview/');
        } else {
            redirect('news/admin_news/overview/');
        }
    }

    /**
     * This function deactivate an news then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function deactivate($id) {
        if ($this->news->is_valid_new($id)) {
            $this->news->deactivate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
            redirect('news/admin_news/overview/');
        } else {
            redirect('news/admin_news/overview/');
        }
    }

    /**
     * This function edit an new then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $data['new'] = $this->news->get_new_one($id);
        $data['categories'] = $this->news->get_category();

        $this->form_validation->set_rules('new_title', $this->lang->line('new_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('new_desc', $this->lang->line('new_desc'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('new_topic', $this->lang->line('new_content'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        $this->form_validation->set_rules('new_category', "القسم", 'trim');
        
        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('new_edit', $data);
        } else {
            if (isset($_FILES['image_file'])) {

                $image_url = $this->upload_image('image_file');
                if ($image_url) {
                    if ($data['new']->ne_img != null) {
                        if (file_exists(PUBPATH . "global/uploads/" . $data['new']->ne_img)) {
                            unlink(PUBPATH . "global/uploads/" . $data['new']->ne_img);
                        }
                    }
                }
            }
            $this->news->update($id, $image_url);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit'));
            redirect('news/admin_news/overview/');
        }
    }

    /**
     * This function sort news then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('news/admin_news/overview');
        } else {
            if ($this->news->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->news->sort($direction, $id);
                        break;
                    case 'down':
                        $this->news->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('news/admin_news/overview');
            } else {
                redirect('news/admin_news/overview');
            }
        }
    }

    /**
     * This function display comments of new
     * @example id=1
     * @param integer $id
     */
    public function comment($id) {
        $data['comments_new'] = $this->news->get_comments_news($id);
        $this->view('news/comments_news_list', $data);
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */