<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class contactus extends front_end {

    function __construct(){
      parent::__construct();
      $this->load->model('contactus_model','contactus');    
      $this->lang->load('contactus/contactus');
      $this->load->library('captcha/captcha');
      $this->load->helper('form');
      $this->load->helper('email');
      $this->load->library('email');
      $this->load->library('form_validation');
      $this->form_validation->CI =& $this;  
    } 

    function index()
    { 
        $metas = array("page_title" => $this->lang->line('page_user_title'),
            "description" => "اتصل بنا",
            "keywords" => "اتصل بنا");
        
        $this->template->metas($metas);
        $this->view("contactus/site/contactus");
    }
 
    function send() 
    {
        $this->session->set_userdata('cap',$this->input->post('captcha'));
        $this->template->metas('page_title', $this->lang->line('page_user2_title'));
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('TxtName', $this->lang->line('name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('TxtEmail', 'البريد الالكتروني', 'trim|required|xss_clean|valid_email|htmlspecialchars');
        $this->form_validation->set_rules('TxtTitle', 'موضوع الرسالة', 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('TxtContent', 'نص الرسالة', 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('TxtCountry', 'الدولة', 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('captcha', 'كود الصورة', 'trim|required|xss_clean|htmlspecialchars|callback_validate_captcha');
        $this->form_validation->set_message('validate_captcha','أدخل الكود الصحيح');
        //$this->load->view('contactus');
        
        if($this->form_validation->run()== false){
        
        $this->view('site/contactus');
        }else
        {
        $this->contactus->send();
        $config['mailtpye'] = 'html';
        $this->email->initialize($config);
        $this->email->from($this->input->post('TxtEmail'), $this->input->post('TxtName'));
        $this->email->to($this->option->get('site_email'));
        $this->email->subject($this->input->post('TxtTitle'));
        $this->email->message($this->input->post('TxtContent'));
        $this->email->send();
        $data['msg'] = "تم إرسال رسالتك بنجاح";
        $this->view('theme/msg',$data);
        }
    }
    
    function validate_captcha()
    {
        $result = $this->captcha->validate($this->session->userdata('cap'));
        return $result;
    }

    function add_email()
    {
        $this->template->metas('page_title', $this->lang->line('page_user_title'));
         $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
         $this->form_validation->set_rules('TxtEmail', 'البريد الالكتروني', 'trim|required|xss_clean|htmlspecialchars');
         if($this->form_validation->run()== false){
         $this->view('site/add_email');
        }else
        {
          $this->contactus->add_email();
          $this->view('theme/msgsent');
        }
    }
   
}