<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class admin_contactus extends back_end {

    function __construct() {

        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }
                
        $this->load->language('contactus_list');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('contactus_model', 'contactus');
        $this->load->library('form_validation');
        //$this->load->library('ajax');	   

        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index() {
        $this->overview();
    }

    /* display all Msg in datagrid. */

    function overview($row = 0) {
        
        $this->load->library('pagination');
        
        $config['base_url'] = base_url() . "family/admin_family/overview";
        $config['total_rows'] = $this->contactus->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

         $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);
        
        $data['row'] = $row;
        $data['total_rows'] = $this->contactus->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();
        
        $data['contactus'] = $this->contactus->get_list($row);
        $this->view('contactus/contactus_list', $data);
    }

    /* This function call operation function in pages_model
      that's executes some operation according to choice. */

    function operation() {
        $this->contactus->operation();
        redirect('contactus/admin_contactus/overview');
    }

    /* This function remove page in database and delete img
      with new from uploaded folder. */

    function remove($id) {
        // $contactus = $this->contactus->get_new_one($id);
        $this->contactus->delete($id);
        redirect('contactus/admin_contactus/overview/');
    }

    function showmsg($id) {        
        $this->contactus->showmsg($id);
        $data['contactus'] = $this->contactus->showmsg($id);
        $this->unreaded_messages = $this->count_unread_messages();
        $this->view('contactus/msg_show', $data);
    }
    public function count_unread_messages() {
        $this->load->model('contactus/contactus_model', 'contactus');
        return $this->contactus->count_unread();
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */