<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class surgery_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new surgery. */

    function create() {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        $this->db->set('surgery_name', $this->input->post('surgery_name'));
        $this->db->set('surgery_notice', $this->input->post('surgery_notice'));
        $this->db->set('surgery_created', time());
        $this->db->insert('d_surgery');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    /* This function create alert new surgery. */

    function create_alert() {
        $this->db->empty_table('d_surgerynext_alert');
        $this->db->set('chx_days', $this->input->post('chx_days'));
        $this->db->set('chx_created', time());
        $this->db->insert('d_surgerynext_alert');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    function get_alert() {
        $result = $this->db->get('d_surgerynext_alert');
        if ($result->num_rows() > 0) {
            return $result->row();
        } else {
            return FALSE;
        }
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_categories($row) {
        $this->db->order_by('surgery_ord', 'asc');
        $this->db->limit(10, $row);
        $result = $this->db->get('d_surgery');
        return $result->result_array();
    }

    function check_surgery_one($id) {
        $this->db->limit(1);
        $this->db->where('chi_type_id', $id);
        $this->db->where('chi_move_type',2);
        $result = $this->db->get('d_checkupinfo');
        return $result->row();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_all_categories() {
        $this->db->order_by('surgery_ord', 'ASC');
        $result = $this->db->get('d_surgery');
        return $result->result_array();
    }

    ////
    function get_all_category_byjoin() {
       $result = $this->db->query('SELECT
  *
FROM d_surgery
  INNER JOIN d_surgeryinfo
    ON d_surgery.surgery_id = d_surgeryinfo.chi_type_id
GROUP BY d_surgeryinfo.chi_type_id');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function surgery_feed() {
        $this->db->order_by('surgery_ord', 'asc');
        $result = $this->db->get('d_surgery');
        return $result->result_array();
    }

    function surgery_box() {
        $this->db->limit(10);
        $this->db->order_by('surgery_ord', 'asc');
        $result = $this->db->get('d_surgery');
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_surgery");
        return $query->num_rows();
    }

    /* This function delete categor of new from database. */

    function delete($id) {
        $this->db->where('surgery_id', $id);
        $this->db->delete('d_surgery');
        return TRUE;
    }

    function is_valid_surgery($id) {
        $this->db->where('surgery_id', $id);
        $this->db->from('d_surgery');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('surgery_id', $id);
        $this->db->from('d_surgery');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_surgery($id) {
        $this->db->where('surgery_id', $id);
        $result = $this->db->get('d_surgery');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("surgery_ord < $order_by");
            $this->db->order_by('surgery_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("surgery_ord > $order_by");
            $this->db->order_by('surgery_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_surgery');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_surgery($id);
        $next_page = $this->_get_next_page($direction, $page['surgery_ord']);
        if (is_array($next_page)) {
            $this->db->set('surgery_ord', $next_page['surgery_ord']);
            $this->db->where('surgery_id', $page['surgery_id']);
            $this->db->update('d_surgery');

            $this->db->set('surgery_ord', $page['surgery_ord']);
            $this->db->where('surgery_id', $next_page['surgery_id']);
            $this->db->update('d_surgery');

            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('surgery_ord');
        $result = $this->db->get('d_surgery');
        $row = $result->row();
        $max_ord = $row->surgery_ord + 1;
        $this->db->where('surgery_id', $id);
        $this->db->set('surgery_ord', $max_ord);
        $this->db->update('d_surgery');
        return TRUE;
    }

    function update($id) {

        $this->db->where('surgery_id', $id);
        $this->db->set('surgery_name', $this->input->post('surgery_name'));
        $this->db->set('surgery_notice', $this->input->post('surgery_notice'));
        $this->db->update('d_surgery');
        return TRUE;
    }

    function get_surgery_one($id) {
        $this->db->where('surgery_id', $id);
        $result = $this->db->get('d_surgery');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('surgery_id', $products[$i]);
                        $this->db->set('surgery_hide', '1');
                        $this->db->update('d_surgery');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('surgery_id', $products[$i]);
                        $this->db->set('surgery_hide', '0');
                        $this->db->update('d_surgery');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":

                        $this->db->where('surgery_id', $products[$i]);
                        $this->db->delete('d_surgery');
                        $this->db->where('surgery_id', $products[$i]);
                        $this->db->delete('d_surgery');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('surgery_hide', '1');
                    $this->db->update('d_surgery');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                    break;
                case "inactive":
                    $this->db->set('surgery_hide', '0');
                    $this->db->update('d_surgery');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                    break;
                case "delete":
                    $this->db->empty_table('d_surgery');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                    break;
            }
        }
    }

    function get_all_for_dropdown() {
        $this->db->select('surgery_id, surgery_name');
        $result = $this->db->get('d_surgery');
        $return = array();
        if ($result->num_rows() > 0) {
            $return[''] = '--اختر--';    // default selection item
            foreach ($result->result_array() as $row) {
                $return[$row['surgery_id']] = $row['surgery_name'];
            }
        }

        return $return;
    }

}
