<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class medicaleq_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new medicaleq. */

    function create() {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        $this->db->set('medicaleq_name', $this->input->post('medicaleq_name'));
        $this->db->set('medicaleq_notice', $this->input->post('medicaleq_notice'));
        $this->db->set('medicaleq_created', time());
        $this->db->insert('d_medicaleq');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    /* This function create alert new medicaleq. */

    function create_alert() {
        $this->db->empty_table('d_medicaleqnext_alert');
        $this->db->set('chx_days', $this->input->post('chx_days'));
        $this->db->set('chx_created', time());
        $this->db->insert('d_medicaleqnext_alert');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    function get_alert() {
        $result = $this->db->get('d_medicaleqnext_alert');
        if ($result->num_rows() > 0) {
            return $result->row();
        } else {
            return FALSE;
        }
    }
    function check_medicalq_one($id) {
        $this->db->limit(1);
        $this->db->where('chi_type_id', $id);
        $this->db->where('chi_move_type',3);
        $result = $this->db->get('d_checkupinfo');
        return $result->row();
    }
    /*  This function get all categories of city from database sort by order asc. */

    function get_categories($row) {
        $this->db->order_by('medicaleq_ord', 'asc');
        $this->db->limit(10, $row);
        $result = $this->db->get('d_medicaleq');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_all_categories() {
        $this->db->order_by('medicaleq_ord', 'ASC');
        $result = $this->db->get('d_medicaleq');
        return $result->result_array();
    }

    ////
    function get_all_category_byjoin() {
       $result = $this->db->query('SELECT
  *
FROM d_medicaleq
  INNER JOIN d_medicaleqinfo
    ON d_medicaleq.medicaleq_id = d_medicaleqinfo.chi_type_id
GROUP BY d_medicaleqinfo.chi_type_id');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function medicaleq_feed() {
        $this->db->order_by('medicaleq_ord', 'asc');
        $result = $this->db->get('d_medicaleq');
        return $result->result_array();
    }

    function medicaleq_box() {
        $this->db->limit(10);
        $this->db->order_by('medicaleq_ord', 'asc');
        $result = $this->db->get('d_medicaleq');
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_medicaleq");
        return $query->num_rows();
    }

    /* This function delete categor of new from database. */

    function delete($id) {
        $this->db->where('medicaleq_id', $id);
        $this->db->delete('d_medicaleq');
        return TRUE;
    }

    function is_valid_medicaleq($id) {
        $this->db->where('medicaleq_id', $id);
        $this->db->from('d_medicaleq');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('medicaleq_id', $id);
        $this->db->from('d_medicaleq');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_medicaleq($id) {
        $this->db->where('medicaleq_id', $id);
        $result = $this->db->get('d_medicaleq');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("medicaleq_ord < $order_by");
            $this->db->order_by('medicaleq_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("medicaleq_ord > $order_by");
            $this->db->order_by('medicaleq_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_medicaleq');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_medicaleq($id);
        $next_page = $this->_get_next_page($direction, $page['medicaleq_ord']);
        if (is_array($next_page)) {
            $this->db->set('medicaleq_ord', $next_page['medicaleq_ord']);
            $this->db->where('medicaleq_id', $page['medicaleq_id']);
            $this->db->update('d_medicaleq');

            $this->db->set('medicaleq_ord', $page['medicaleq_ord']);
            $this->db->where('medicaleq_id', $next_page['medicaleq_id']);
            $this->db->update('d_medicaleq');

            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('medicaleq_ord');
        $result = $this->db->get('d_medicaleq');
        $row = $result->row();
        $max_ord = $row->medicaleq_ord + 1;
        $this->db->where('medicaleq_id', $id);
        $this->db->set('medicaleq_ord', $max_ord);
        $this->db->update('d_medicaleq');
        return TRUE;
    }

    function update($id) {

        $this->db->where('medicaleq_id', $id);
        $this->db->set('medicaleq_name', $this->input->post('medicaleq_name'));
        $this->db->set('medicaleq_notice', $this->input->post('medicaleq_notice'));
        $this->db->update('d_medicaleq');
        return TRUE;
    }

    function get_medicaleq_one($id) {
        $this->db->where('medicaleq_id', $id);
        $result = $this->db->get('d_medicaleq');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('medicaleq_id', $products[$i]);
                        $this->db->set('medicaleq_hide', '1');
                        $this->db->update('d_medicaleq');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('medicaleq_id', $products[$i]);
                        $this->db->set('medicaleq_hide', '0');
                        $this->db->update('d_medicaleq');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":

                        $this->db->where('medicaleq_id', $products[$i]);
                        $this->db->delete('d_medicaleq');
                        $this->db->where('medicaleq_id', $products[$i]);
                        $this->db->delete('d_medicaleq');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('medicaleq_hide', '1');
                    $this->db->update('d_medicaleq');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                    break;
                case "inactive":
                    $this->db->set('medicaleq_hide', '0');
                    $this->db->update('d_medicaleq');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                    break;
                case "delete":
                    $this->db->empty_table('d_medicaleq');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                    break;
            }
        }
    }

    function get_all_for_dropdown() {
        $this->db->select('medicaleq_id, medicaleq_name');
        $result = $this->db->get('d_medicaleq');
        $return = array();
        if ($result->num_rows() > 0) {
            $return[''] = '--اختر--';    // default selection item
            foreach ($result->result_array() as $row) {
                $return[$row['medicaleq_id']] = $row['medicaleq_name'];
            }
        }

        return $return;
    }

}
