<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class checkup_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new checkup. */

    function create() {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        $this->db->set('checkup_name', $this->input->post('checkup_name'));
        $this->db->set('checkup_notice', $this->input->post('checkup_notice'));
        $this->db->set('checkup_created', time());
        $this->db->insert('d_checkup');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    /* This function create alert new checkup. */

    function create_alert() {
        $this->db->empty_table('d_checkupnext_alert');
        $this->db->set('chx_days', $this->input->post('chx_days'));
        $this->db->set('chx_created', time());
        $this->db->insert('d_checkupnext_alert');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    function get_alert() {
        $result = $this->db->get('d_checkupnext_alert');
        if ($result->num_rows() > 0) {
            return $result->row();
        } else {
            return FALSE;
        }
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_categories($row) {
        $this->db->order_by('checkup_ord', 'asc');
        $this->db->limit(10, $row);
        $result = $this->db->get('d_checkup');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_all_categories() {
        $this->db->order_by('checkup_ord', 'ASC');
        $result = $this->db->get('d_checkup');
        return $result->result_array();
    }

    ////
    function get_all_category_byjoin() {
       $result = $this->db->query('SELECT
  *
FROM d_checkup
  INNER JOIN d_checkupinfo
    ON d_checkup.checkup_id = d_checkupinfo.chi_type_id
GROUP BY d_checkupinfo.chi_type_id');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function checkup_feed() {
        $this->db->order_by('checkup_ord', 'asc');
        $result = $this->db->get('d_checkup');
        return $result->result_array();
    }

    function checkup_box() {
        $this->db->limit(10);
        $this->db->order_by('checkup_ord', 'asc');
        $result = $this->db->get('d_checkup');
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_checkup");
        return $query->num_rows();
    }

    /* This function delete categor of new from database. */

    function delete($id) {
        $this->db->where('checkup_id', $id);
        $this->db->delete('d_checkup');
        return TRUE;
    }

    function is_valid_checkup($id) {
        $this->db->where('checkup_id', $id);
        $this->db->from('d_checkup');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('checkup_id', $id);
        $this->db->from('d_checkup');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_checkup($id) {
        $this->db->where('checkup_id', $id);
        $result = $this->db->get('d_checkup');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("checkup_ord < $order_by");
            $this->db->order_by('checkup_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("checkup_ord > $order_by");
            $this->db->order_by('checkup_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_checkup');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_checkup($id);
        $next_page = $this->_get_next_page($direction, $page['checkup_ord']);
        if (is_array($next_page)) {
            $this->db->set('checkup_ord', $next_page['checkup_ord']);
            $this->db->where('checkup_id', $page['checkup_id']);
            $this->db->update('d_checkup');

            $this->db->set('checkup_ord', $page['checkup_ord']);
            $this->db->where('checkup_id', $next_page['checkup_id']);
            $this->db->update('d_checkup');

            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('checkup_ord');
        $result = $this->db->get('d_checkup');
        $row = $result->row();
        $max_ord = $row->checkup_ord + 1;
        $this->db->where('checkup_id', $id);
        $this->db->set('checkup_ord', $max_ord);
        $this->db->update('d_checkup');
        return TRUE;
    }

    function update($id) {

        $this->db->where('checkup_id', $id);
        $this->db->set('checkup_name', $this->input->post('checkup_name'));
        $this->db->set('checkup_notice', $this->input->post('checkup_notice'));
        $this->db->update('d_checkup');
        return TRUE;
    }
    function get_checkup_one($id) {
        $this->db->where('checkup_id', $id);
        $result = $this->db->get('d_checkup');
        return $result->row();
    }

    function check_checkup_one($id) {
        $this->db->limit(1);
        $this->db->where('chi_type_id', $id);
        $this->db->where('chi_move_type',1);
        $result = $this->db->get('d_checkupinfo');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('checkup_id', $products[$i]);
                        $this->db->set('checkup_hide', '1');
                        $this->db->update('d_checkup');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('checkup_id', $products[$i]);
                        $this->db->set('checkup_hide', '0');
                        $this->db->update('d_checkup');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":

                        $this->db->where('checkup_id', $products[$i]);
                        $this->db->delete('d_checkup');
                        $this->db->where('checkup_id', $products[$i]);
                        $this->db->delete('d_checkup');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('checkup_hide', '1');
                    $this->db->update('d_checkup');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                    break;
                case "inactive":
                    $this->db->set('checkup_hide', '0');
                    $this->db->update('d_checkup');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                    break;
                case "delete":
                    $this->db->empty_table('d_checkup');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                    break;
            }
        }
    }

    function get_all_for_dropdown() {
        $this->db->select('checkup_id, checkup_name');
        $result = $this->db->get('d_checkup');
        $return = array();
        if ($result->num_rows() > 0) {
            $return[''] = '--اختر--';    // default selection item
            foreach ($result->result_array() as $row) {
                $return[$row['checkup_id']] = $row['checkup_name'];
            }
        }

        return $return;
    }

}
