<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_medicaleq extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('checkup/medicaleq');
        $this->template->metas('page_title', $this->lang->line('page_title_cat'));
        $this->load->model('medicaleq_model', 'medicaleq');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->check_right('manage_checkup', 'admin/dashboard');

        $this->overview();
    }

    /**
     *  create new new_medicaleq then redirect overview.
     */
    public function create() {
        $this->check_right('add_checkup', 'admin/dashboard');

        $this->form_validation->set_rules('medicaleq_name', $this->lang->line('medicaleq_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('medicaleq_notice', $this->lang->line('medicaleq_notice'), 'trim|xss_clean');

        $this->form_validation->set_rules('hide', "التفعيل", 'trim');

        if ($this->form_validation->run() == false) {
            $this->view('medicaleq_new');
        } else {
            $this->medicaleq->create();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('checkup/admin_medicaleq/overview/');
        }
    }

    /**
     *  create new new_medicaleq then redirect overview.
     */
    public function create_alert() {
        $this->check_right('add_checkup', 'admin/dashboard');

        $this->form_validation->set_rules('chx_days', $this->lang->line('medicaleq_days'), 'integer|trim|required|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() == false) {
            $data['alert'] = $this->medicaleq->get_alert();
            $this->view('medicaleq_alert_new',$data);
        } else {
            $this->medicaleq->create_alert();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('checkup/admin_medicaleq/overview/');
        }
    }

    function export_medicaleq_reprt() {

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;
        $data['all_medicaleqs'] = $this->medicaleq->get_all_categories();
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('checkup/print_medicaleqs', $data, true); // render the view into HTML
        if ($casetype == 1) {
            //$header1 = '<img src="http://dt-works.com/amd/pdfgen/global/site/images/togary_2.png" alt="" style="margin:-11mm -15mm 0"/><b>اختصاص</b>';
            $header1 = '<img src="http://localhost/alsalam/global/site/images/header-img_06.png" alt="" style="margin:-11mm -15mm 0"/><b>اختصاص</b>';
            $pdf->SetHTMLHeader("$header1");
        }

        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'medicaleq_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
        exit();
        redirect('checkup/admin_medicaleq');
    }

    /**
     *  display all categories of city in datagrid.
     */
    public function overview($row = 0) {
        $this->check_right('manage_checkup', 'admin/dashboard');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "checkup/admin_medicaleq/overview";
        $config['total_rows'] = $this->medicaleq->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->medicaleq->getNumUsersAdmin();

        $data['links'] = $this->pagination->create_links();

        $data['categories'] = $this->medicaleq->get_categories($row);

        $this->view('medicaleq_list', $data);
    }

    /**
     *  This function call operation function in medicaleq_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->medicaleq->operation();
        redirect('checkup/admin_medicaleq/overview');
    }

    /**
     * This function remove new_medicaleq then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $this->check_right('remove_checkup', 'admin/dashboard');
        $one = $this->medicaleq->check_medicalq_one($id);

        if (empty($one)) {
            $this->medicaleq->delete($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect('checkup/admin_medicaleq/overview/');
        }else{
            $this->session->set_flashdata('error_msg','لا يمكنك الحذف،هناك معاينات مرتبطة');
            redirect_back();
        }
    }

    /**
     *  This function activate an new_medicaleq then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->medicaleq->is_valid_medicaleq($id)) {
            $this->medicaleq->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_cat'));
            redirect('checkup/admin_medicaleq/overview/');
        } else {
            redirect('checkup/admin_medicaleq/overview/');
        }
    }

    public function deactivate($id) {
        $this->medicaleq->deactivate($id);
        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_cat'));
        redirect('checkup/admin_medicaleq/overview/');
    }

    /**
     * This function edit an new_medicaleq then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $this->check_right('edit_checkup', 'admin/dashboard');

        $data['medicaleq'] = $this->medicaleq->get_medicaleq_one($id);
        $this->form_validation->set_rules('medicaleq_name', $this->lang->line('medicaleq_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('medicaleq_notice', $this->lang->line('medicaleq_notice'), 'trim|xss_clean');

        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('medicaleq_edit', $data);
        } else {
            $this->medicaleq->update($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit_cat'));
            redirect('checkup/admin_medicaleq/overview/');
        }
    }

    /**
     * This function sort medicaleq then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('checkup/admin_medicaleq/overview/');
        } else {
            if ($this->medicaleq->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->medicaleq->sort($direction, $id);
                        break;
                    case 'down':
                        $this->medicaleq->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('checkup/admin_medicaleq/overview/');
            } else {
                redirect('checkup/admin_medicaleq/overview/');
            }
        }
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */