<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_charge extends back_end {

    private $pagesize = 10;

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('charge/charge');
        $this->template->metas('page_title', $this->lang->line('page_title'));
        $this->load->model('charge_model', 'charge');
        $this->load->helper('rupiah');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    /**
     * This function display all charge in datagrid.
     * @example row=1
     * @param integer $row
     */
    public function overview() {
        $this->index();
    }

    // search filter
    function index() {
        $this->check_right('manage_charge', 'admin/dashboard');

        $this->charge->limit = 5;
        $this->charge->offset = $this->uri->segment(3);

        $result['query'] = $this->charge->listBarang();
        $result['numrec'] = $this->charge->numRec();

        $this->view('charge_list', $result);
    }

    function search_barang() {
        if (isset($_POST['descp_msg']) && $_POST['descp_msg'] != NULL) {
            $vDescp = $_POST['descp_msg'];
        } else
            $vDescp = '';

        if (isset($_POST['pageNumber']) && $_POST['pageNumber'] != NULL) {
            $idoffset = $_POST['pageNumber'] - 1;
        } else
            $idoffset = 0;

        $this->charge->limit = $this->pagesize;
        $this->charge->offset = $idoffset * $this->pagesize;
        $result['offset'] = $this->charge->offset;
        $result['rec'] = $this->charge->numRec_page($vDescp);
        $result['query'] = $this->charge->listBarang_page($vDescp);

        $this->load->view('charge_list_page', $result);
    }

    /**
     *  create charge charge then redirect on overview.
     */
    public function create() {
        $this->check_right('add_charge', 'admin/dashboard');

        $this->load->model('checkup/checkup_model', 'checkup');
        $this->load->model('branch/branch_model', 'branch');
        $data['branch_category'] = $this->branch->get_all_for_dropdown();
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();
        $this->form_validation->set_rules('chg_pi_id', $this->lang->line('chg_pi_id'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_pi_num', $this->lang->line('chg_pi_num'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_branch_id', $this->lang->line('chg_branch_id'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_date', $this->lang->line('chg_date'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_type', $this->lang->line('chg_type'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_phone', $this->lang->line('chg_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_cost', $this->lang->line('chg_cost'), 'integer|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_address', $this->lang->line('chg_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_steps', $this->lang->line('chg_steps'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_notice', $this->lang->line('chg_notice'), 'trim|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() == false) {
//        chg_branch_id
            if ($this->input->post("action") == 'القائمة') {
                redirect('charge/admin_charge/overview');
            }
            $this->view('charge_new', $data);
        } else {
            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->charge->create();
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('charge/admin_charge/overview/');
            } else if ($this->input->post("action") == 'حفظ وطباعة') {
                $this->charge->create();
                $id = $this->charge->get_max_id();
                redirect("charge/admin_charge/edit/$id->chg_id");
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('charge/admin_charge/overview');
            } else {
                $this->charge->create();
                $id = $this->charge->get_max_id();
                redirect("charge/admin_charge/edit/$id->chg_id");
            }
        }
    }

    /**
     * used to find citis according to live search inputs value
     * @param string $KeyWord 
     */
//    function search($rowClass = 'rowOne1', $KeyWord = '') {
//        //$this->profiler();
//        $this->load->model('branch/branch_model', 'branch');
//        $data['rowClass'] = $rowClass;
//        $data['SearchResults'] = $this->branch->search(trim(urldecode($KeyWord)));
//        $this->load->view("charge/search_results", $data);
//    }
    public function autocomplete() {
        $pi_name = $this->input->post('pi_name');

        $query = $this->charge->get_autocomplete($pi_name);
        foreach ($query->result() as $row):
            echo "<li class='branch' id='{$row->pi_name}  {$row->pi_father}  {$row->pi_family}- {$row->pi_num}- {$row->pi_branch_id}- {$row->branch_name}- {$row->pi_id}'>{$row->pi_name} {$row->pi_father} {$row->pi_family}</li>";
        endforeach;
    }

    public function autocompletesearch() {
        $pi_name = $this->input->post('pi_name');

        $query = $this->charge->get_autocomplete($pi_name);
        foreach ($query->result() as $row):
            echo "<li class='branch' id=' {
    $row->pi_name}</li>";
        endforeach;
    }

// load search from
    public function charge_search() {
        $this->check_right('search_charge', 'admin/dashboard');
        $this->load->model('checkup/checkup_model', 'checkup');
        $this->load->model('branch/branch_model', 'branch');
        $data['branch_category'] = $this->branch->get_all_for_dropdown();
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();

        $this->view('charge/charge_search', $data);
    }

// get advanced search
    public function charge_result() {
        $chg_pi_id = $this->input->post('chg_pi_id');
        $chg_cost = $this->input->post('chg_cost');
        $chg_date = $this->input->post('chg_date');
        $chg_date2 = $this->input->post('chg_date2');
        $data['chg_date'] = $this->input->post('chg_date');
        $data['chg_date2'] = $this->input->post('chg_date2');
        $pi_name = $this->input->post('pi_name');
        $chg_type = $this->input->post('chg_type');
        $chg_branch_id = $this->input->post('chg_branch_id');
        $data['result1'] = '';
        if ($chg_pi_id == NULL and $chg_cost == NULL and $chg_date == NULL and $chg_date2 == NULL and $pi_name == NULL and $chg_type == NULL and $chg_branch_id == NULL) {
            $this->charge_search();
        } else {
            $this->load->library('pdf');
            $pdf = $this->pdf->load();
            $pdf->allow_charset_conversion=true;  // Set by default to TRUE
            $pdf->charset_in='UTF-8';
            $pdf->SetDirectionality('rtl');
            $pdf->autoLangToFont = true;

            $data['all_charge'] = $this->charge->search_all();
            //          echo $this->db->last_query();exit;
            //          print_r($data['all_charge']) ;exit;
            //       
            ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
            $html = $this->load->view('charge/print_charges', $data, true); // render the view into HTML
            //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
            // Create a stream
            // $pdf->mirrorMargins = 1;
            $pdf->WriteHTML($html); // write the HTML into the PDF
            $output = 'charge_report' . date('Y_m_d_H_i_s') . '_.pdf';
            $pdf->Output("$output", 'I'); // save to file because we can
            exit();
            redirect('charge/admin_charge');
            $data['no_results'] = '';
            if (!$data['result1']) {
                $data['no_results'] = TRUE;
            } else {
                $data['no_results'] = FALSE;
            }
            $this->view('charge/charge_result', $data);
        }
    }

    function export_charge_reprt() {
        $this->check_right('print_charge', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['all_charge'] = $this->charge->get_all();
        //        echo $this->db->last_query();exit;
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('charge/print_charges', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'charge_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
        exit();
        redirect('charge/admin_charge');
    }

    function export_onecharge_reprt($id) {
        $this->check_right('print_charge', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;

        $data['charge'] = $this->charge->get_one($id);
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('charge/print_charge', $data, true); // render the view into HTML
        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'charge_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
        exit();
        redirect('charge/admin_charge');
    }

    /**
     * This function call operation function in charge_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->charge->operation();
        redirect('charge/admin_charge/overview');
    }

    /**
     * This function remove charge then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $this->check_right('remove_charge', 'admin/dashboard');

        if ($this->charge->delete($id)) {
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect_back();
        }
    }

    /**
     *  This function activate an charge then redirect to overview
     * @example id=1
     * @param integer $id
     */
    //    public function activate($id) {
    //        if ($this->charge->is_valid_charge($id)) {
    //            $this->charge->activate($id);
    //            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active'));
    //            redirect('charge/admin_charge/overview/');
    //        } else {
    //            redirect('charge/admin_charge/overview/');
    //        }
    //    }
    //
    //    /**
    //     * This function deactivate an charge then redirect to overview
    //     * @example id=1
    //     * @param integer $id
    //     */
    //    public function deactivate($id) {
    //        if ($this->charge->is_valid_charge($id)) {
    //            $this->charge->deactivate($id);
    //            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive'));
    //            redirect('charge/admin_charge/overview/');
    //        } else {
    //            redirect('charge/admin_charge/overview/');
    //        }
    //    }

    /**
     * This function edit an charge then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $this->check_right('edit_charge', 'admin/dashboard');

        $this->load->model('checkup/checkup_model', 'checkup');
        $data['charge'] = $this->charge->get_charge_one($id);
        $data['branch_category'] = $this->charge->get_one($id);
        $data['checkup_category'] = $this->checkup->get_all_for_dropdown();

        $this->form_validation->set_rules('chg_pi_id', $this->lang->line('chg_pi_id'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_branch_id', $this->lang->line('chg_branch_id'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_date', $this->lang->line('chg_date'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_type', $this->lang->line('chg_type'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_phone', $this->lang->line('chg_phone'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_cost', $this->lang->line('chg_cost'), 'integer|trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_address', $this->lang->line('chg_address'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_steps', $this->lang->line('chg_steps'), 'trim|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('chg_notice', $this->lang->line('chg_notice'), 'trim|xss_clean|htmlspecialchars');

        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('charge_edit', $data);
        } else {
            if ($this->input->post("action") == 'حفظ') {
                //action for update here
                $this->charge->update($id);
                $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
                redirect('charge/admin_charge/overview/');
            } else if ($this->input->post("action") == 'طباعة') {
                $this->export_onecharge_reprt($id);
            } else if ($this->input->post("action") == 'القائمة') {
                redirect('charge/admin_charge/overview');
            } else {
                $this->charge->update($id);
                $id = $this->charge->get_max_id();
                redirect("charge/admin_charge/edit/$id");
            }
        }
    }

    /**
     * This function sort charge then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('charge/admin_charge/overview');
        } else {
            if ($this->charge->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->charge->sort($direction, $id);
                        break;
                    case 'down':
                        $this->charge->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('charge/admin_charge/overview');
            } else {
                redirect('charge/admin_charge/overview');
            }
        }
    }

    /**
     * This function display comments of charge
     * @example id=1
     * @param integer $id
     */
    public function comment($id) {
        $data['comments_charge'] = $this->charge->get_comments_charge($id);
        $this->view('charge/comments_charge_list', $data);
    }

}

/* End of file dashboard.php */
    /* Location: ./system/application/modules/matchbox/controllers/dashboard.php */