<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class branch_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }

    /* This function create new branch. */

    function create() {
        if ($this->input->post('hide'))
            $hide = 1;
        else
            $hide = 0;
        $this->db->set('branch_name', $this->input->post('branch_name'));
        $this->db->set('branch_notice', $this->input->post('branch_notice'));
        $this->db->set('branch_created', time());
        $this->db->insert('d_branch');
        $id = $this->db->insert_id();
        $this->_update_page_assoc($id);
        return TRUE;
    }

    /*  This function get all categories of city from database sort by order asc. */

    function get_categories($row) {
        $this->db->order_by('branch_ord', 'asc');
        $this->db->limit(10, $row);
        $result = $this->db->get('d_branch');
        return $result->result_array();
    }
    /*  This function get all categories of city from database sort by order asc. */

    function get_all_categories() {
        $this->db->order_by('branch_ord', 'ASC');
        $result = $this->db->get('d_branch');
        return $result->result_array();
    }

    /*  This function get all categories of city from database sort by order asc. */

    function branch_feed() {
        $this->db->order_by('branch_ord', 'asc');
        $result = $this->db->get('d_branch');
        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_branch");
        return $query->num_rows();
    }

    /* This function delete categor of new from database. */

    function delete($id) {
        $this->db->where('branch_id', $id);
        $this->db->delete('d_branch');
        return TRUE;
    }

    function is_valid_branch($id) {
        $this->db->where('branch_id', $id);
        $this->db->from('d_branch');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function is_valid_page($id) {
        $this->db->where('branch_id', $id);
        $this->db->from('d_branch');
        if ($this->db->count_all_results() > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function get_branch($id) {
        $this->db->where('branch_id', $id);
        $result = $this->db->get('d_branch');
        if ($result->num_rows() > 0) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function _get_next_page($direction, $order_by) {
        if ($direction == 'up') {
            $this->db->where("branch_ord < $order_by");
            $this->db->order_by('branch_ord', 'desc');
            $this->db->limit(1, 0);
        } else {
            $this->db->where("branch_ord > $order_by");
            $this->db->order_by('branch_ord', 'asc');
            $this->db->limit(1, 0);
        }
        $result = $this->db->get('d_branch');
        if ($result->num_rows() == 1) {
            return $result->row_array();
        } else {
            return FALSE;
        }
    }

    function sort($direction, $id) {
        $page = $this->get_branch($id);
        $next_page = $this->_get_next_page($direction, $page['branch_ord']);
        if (is_array($next_page)) {
            $this->db->set('branch_ord', $next_page['branch_ord']);
            $this->db->where('branch_id', $page['branch_id']);
            $this->db->update('d_branch');

            $this->db->set('branch_ord', $page['branch_ord']);
            $this->db->where('branch_id', $next_page['branch_id']);
            $this->db->update('d_branch');

            return TRUE;
        } else {
            return FALSE;
        }
    }

    function _update_page_assoc($id) {
        $this->db->select_max('branch_ord');
        $result = $this->db->get('d_branch');
        $row = $result->row();
        $max_ord = $row->branch_ord + 1;
        $this->db->where('branch_id', $id);
        $this->db->set('branch_ord', $max_ord);
        $this->db->update('d_branch');
        return TRUE;
    }

    function update($id) {

        $this->db->where('branch_id', $id);
        $this->db->set('branch_name', $this->input->post('branch_name'));
        $this->db->set('branch_notice', $this->input->post('branch_notice'));
        $this->db->update('d_branch');
        return TRUE;
    }

    function get_branch_one($id) {
        $this->db->where('branch_id', $id);
        $result = $this->db->get('d_branch');
        return $result->row();
    }

    function operation() {
        if (!empty($_POST['check_nf'])) {
            $products = $_POST['check_nf'];
            for ($i = 0; $i <= count($products) - 1; $i++) {
                switch ($_POST['operation']) {
                    case "active":
                        $this->db->where('branch_id', $products[$i]);
                        $this->db->set('branch_hide', '1');
                        $this->db->update('d_branch');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                        break;

                    case "inactive":
                        $this->db->where('branch_id', $products[$i]);
                        $this->db->set('branch_hide', '0');
                        $this->db->update('d_branch');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                        break;

                    case "delete":

                        $this->db->where('branch_id', $products[$i]);
                        $this->db->delete('d_branch');
                        $this->db->where('branch_id', $products[$i]);
                        $this->db->delete('d_branch');
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
        if (isset($_POST['check_nf2'])) {
            $products = $_POST['check_nf2'];
            switch ($_POST['operation']) {
                case "active":
                    $this->db->set('branch_hide', '1');
                    $this->db->update('d_branch');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_all'));
                    break;
                case "inactive":
                    $this->db->set('branch_hide', '0');
                    $this->db->update('d_branch');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_all'));
                    break;
                case "delete":
                    $this->db->empty_table('d_branch');
                    $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                    break;
            }
        }
    }

    function get_all_for_dropdown() {
        $this->db->select('branch_id, branch_name');
        $result = $this->db->get('d_branch');
        $return = array();
        if ($result->num_rows() > 0) {
            $return[''] = '--اختر--';    // default selection item
            foreach ($result->result_array() as $row) {
                $return[$row['branch_id']] = $row['branch_name'];
            }
        }

        return $return;
    }


}
