<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin_branch extends back_end {

    function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->lang->load('branch/branch');
        $this->template->metas('page_title', $this->lang->line('page_title_cat'));
        $this->load->model('branch_model', 'branch');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    public function index() {
        $this->check_right('manage_branch', 'admin/dashboard');

        $this->overview();
    }

    /**
     *  create new new_branch then redirect overview.
     */
    public function create() {
        $this->check_right('add_branch', 'admin/dashboard');

        $this->form_validation->set_rules('branch_name', $this->lang->line('branch_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('branch_notice', $this->lang->line('branch_notice'), 'trim|xss_clean');

        $this->form_validation->set_rules('hide', "التفعيل", 'trim');

        if ($this->form_validation->run() == false) {
            $this->view('branch_new');
        } else {
            $this->branch->create();
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg'));
            redirect('branch/admin_branch/overview/');
        }
    }

    function export_branch_reprt() {
        $this->check_right('print_branch', 'admin/dashboard');

        $this->load->library('pdf');
        $pdf = $this->pdf->load();
        $pdf->allow_charset_conversion=true;  // Set by default to TRUE
        $pdf->charset_in='UTF-8';
        $pdf->SetDirectionality('rtl');
        $pdf->autoLangToFont = true;
        $data['all_branches'] = $this->branch->get_all_categories();
        ini_set('memory_limit', '32M'); // boost the memory limit if it's low ;)
        $html = $this->load->view('branch/print_branches', $data, true); // render the view into HTML
        if ($casetype == 1) {

            //$header1 = '<img src="http://dt-works.com/amd/pdfgen/global/site/images/togary_2.png" alt="" style="margin:-11mm -15mm 0"/><b>اختصاص</b>';
            $header1 = '<img src="' . base_url() . 'global/site/images/header-img_06.png" alt="" style="margin:-11mm -15mm 0"/><b>اختصاص</b>';
            $pdf->SetHTMLHeader("$header1");
        }

        //$pdf->SetHTMLFooter('<div style="height:20mm;padding-bottom:-10mm;"><p style="width:10mm;float:left;padding-bottom:-30mm;">{PAGENO}</p><img src="http://dt-works.com/amd/pdfgen/global/site/images/footer-left.png" alt="" style="width:14mm ;height:20mm;float:left" ;/></div>', 'E');
        // Create a stream
        // $pdf->mirrorMargins = 1;
        $pdf->WriteHTML($html); // write the HTML into the PDF
        $output = 'branch_report' . date('Y_m_d_H_i_s') . '_.pdf';
        $pdf->Output("$output", 'I'); // save to file because we can
        exit();
        redirect('branch/admin_branch');
    }

    /**
     *  display all categories of city in datagrid.
     */
    public function overview($row = 0) {
        $this->check_right('manage_branch', 'admin/dashboard');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "branch/admin_branch/overview";
        $config['total_rows'] = $this->branch->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';

        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->branch->getNumUsersAdmin();

        $data['links'] = $this->pagination->create_links();

        $data['categories'] = $this->branch->get_categories($row);

        $this->view('branch_list', $data);
    }

    /**
     *  This function call operation function in branch_model
      that's executes some operation according to choice.
     */
    public function operation() {
        $this->branch->operation();
        redirect('branch/admin_branch/overview');
    }

    /**
     * This function remove new_branch then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function remove($id) {
        $this->check_right('remove_branch', 'admin/dashboard');

        $new = $this->branch->get_branch_one($id);
        if ($this->branch->delete($id)) {
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del'));
            redirect_back();
        }
    }

    /**
     *  This function activate an new_branch then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function activate($id) {
        if ($this->branch->is_valid_branch($id)) {
            $this->branch->activate($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_active_cat'));
            redirect('branch/admin_branch/overview/');
        } else {
            redirect('branch/admin_branch/overview/');
        }
    }

    public function deactivate($id) {
        $this->branch->deactivate($id);
        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_inactive_cat'));
        redirect('branch/admin_branch/overview/');
    }

    /**
     * This function edit an new_branch then redirect to overview
     * @example id=1
     * @param integer $id
     */
    public function edit($id) {
        $this->check_right('edit_branch', 'admin/dashboard');

        $data['branch'] = $this->branch->get_branch_one($id);
        $this->form_validation->set_rules('branch_name', $this->lang->line('branch_title'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('branch_notice', $this->lang->line('branch_notice'), 'trim|xss_clean');

        $this->form_validation->set_rules('hide', "التفعيل", 'trim');
        //$this->form_validation->set_rules('lang', 'اللغة', 'trim|required|xss_clean|htmlspecialchars');
        if ($this->form_validation->run() == false) {
            $this->view('branch_edit', $data);
        } else {
            $this->branch->update($id);
            $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_edit_cat'));
            redirect('branch/admin_branch/overview/');
        }
    }

    /**
     * This function sort branch then redirect to overview
     * @example direction ='up', $id =1
     * @param string $direction
     * @param integer $id
     */
    public function sort($direction = 'up', $id = FALSE) {
        if ($id == FALSE) {
            redirect('branch/admin_branch/overview/');
        } else {
            if ($this->branch->is_valid_page($id)) {
                switch ($direction) {
                    case 'up':
                        $this->branch->sort($direction, $id);
                        break;
                    case 'down':
                        $this->branch->sort($direction, $id);
                        break;
                    default:
                        break;
                }
                redirect('branch/admin_branch/overview/');
            } else {
                redirect('branch/admin_branch/overview/');
            }
        }
    }

}

/* End of file dashboard.php */
/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */
