<?php if (!defined('BASEPATH')) exit('No direct script access allowed');



/**

 *

 * @property CI_DB_active_record $db

 * @property CI_Input $input


 * @property CI_Pagination $pagination

 * @author Mohamed Mahdy <eng.mohamed.php@gmail.com>

 * @copyright Copyright (c) 2011, Web Developer <Mohamed Mahdy>

 */

class star_users_model extends CI_Model {



    /**

     *

     * static ids cannot be deleted

     *

     * admin = 1

     *

     * @var integer

     *

     */

    private $publisher_group_static_id;



    function __construct() {

        parent::__construct();

        $this->publisher_group_static_id = 2;

    }



    /*  This function get all star_users in database sort by order asc. */



    function get_user_offers($user_id) {
        return $this->db->query("
                SELECT
                  d_book.bo_id,
                  d_book.bo_name,
                  d_book.bo_price,
                  d_book.bo_price * d_star_users.st_us_discount / 100 AS price_after_discount,
                  d_star_users.st_us_ord,
                  d_star_users.st_us_created,
                  d_star_users.st_us_discount,
                  d_star_users.st_us_bookid,
                  d_star_users.st_us_id,
                  d_star_users.st_us_isfree,
                  d_star_users.st_us_updated,
                  d_star_users.st_us_state,
                  d_star_users.st_us_userid
                FROM d_book
                  INNER JOIN d_star_users
                    ON d_book.bo_id = d_star_users.st_us_bookid
                WHERE d_star_users.st_us_userid = '$user_id'
                ")->result_array();
    }



    /**

     *

     * @param integer $group_id

     *

     */

    function get_star_users_by_group($group_id) {

        $this->db->where('user_group_id', $group_id);

        return $this->db->get('star_users')->result_array();

    }



    function get_groups() {

        $this->db->select('groups.*');

        $this->db->from('groups');

        $result = $this->db->get();

        return $result->result_array();

    }



    function get_groups_edit() {

        $this->db->select('groups.*');

        $this->db->from('groups');

        $this->db->where('gr_id !=', $this->publisher_group_static_id);

        $result = $this->db->get();

        return $result->result_array();

    }



    function create($user_id) {

        // insert user informtion

        $this->db->set('st_us_userid', $user_id);

        $this->db->set('st_us_bookid', $this->input->post('book_id'));

        if ($this->input->post('book_free') == "1") {

            $this->db->set('st_us_discount', '0');

        } else {

            $this->db->set('st_us_discount', $this->input->post('book_discount'));

        }

        $this->db->set('st_us_isfree', $this->input->post('book_free'));

        $this->db->set('st_us_state', '1');

        $this->db->set("st_us_created", @date('Y-m-d') . ' ' . $this->input->post('user_created_date'));

        $this->db->insert('star_users');



        // connect star_users with user group

    }



    function is_book_exist($bo_id) {

        $this->db->where('bo_id', $bo_id);

        $result = $this->db->get('book');

        if ($result->num_rows() > 0) {

            return TRUE;

        } else {

            return FALSE;

        }

    }



    function is_book_offered($bo_id, $user_id) {

        $this->db->where('st_us_bookid', $bo_id);

        $this->db->where('st_us_userid', $user_id);

        $result = $this->db->get('star_users');

        if ($result->num_rows() > 0) {

            return TRUE;

        } else {

            return FALSE;

        }

    }



    /**

     * @param integer $id

     */

    function update($id) {



        $this->db->set('st_us_bookid', $this->input->post('book_id'));

        if ($this->input->post('book_free') == "1") {

            $this->db->set('st_us_discount', '0');

        } else {

            $this->db->set('st_us_discount', $this->input->post('book_discount'));

        }

        $this->db->set('st_us_isfree', $this->input->post('book_free'));

        $this->db->where('st_us_id', $id);

        $this->db->update('star_users');

    }



    /**

     *

     * @param integer $id userid

     * @return true if data deleted other wise return false

     */

    function delete($offer_id) {



        $this->db->where('st_us_id', $offer_id);

        $this->db->delete('star_users');

        return TRUE;

    }



    /**

     *

     * delete publisher information

     *

     * @param integer $id userid

     *

     */

    function delete_publishing($id) {

        $user = $this->get_user_one($id);

        if ($user->user_group_id == $this->publisher_group_static_id) {

            $publisher = $this->db->query("SELECT pub_user_id,pub_id FROM d_publishing WHERE pub_user_id = '" . $user->user_id . "'")->row();

            Modules::run('bookstore/admin_d_publishing/remove_d_publishing', $publisher->pub_id); // remove via publisher id

            $this->db->delete('section_bridge', "sec_b_user_id = '$user->user_id'");

            log_message('debug', 'data deleted from publishing for id = ' . $id);

        }

    }



    function is_valid_visitor($id) {

        $this->db->where('e_id', $id);

        $this->db->from('employee');

        if ($this->db->count_all_results() > 0) {

            return TRUE;

        } else {

            return FALSE;

        }

    }



    function is_valid_page($id) {

        $this->db->where('e_id', $id);

        $this->db->from('employee');

        if ($this->db->count_all_results() > 0) {

            return TRUE;

        } else {

            return FALSE;

        }

    }



    function get_page($id) {

        $this->db->where('e_id', $id);

        $result = $this->db->get('employee');

        if ($result->num_rows() > 0) {

            return $result->row_array();

        } else {

            return FALSE;

        }

    }



    function get_star_user_one($offer_id) {

        $result = $this->db->query("select * 

                                    from d_star_users                                     

                                    where st_us_id='$offer_id'");

        return $result->row();

    }



    function get_user_sales($limit, $id = '') {

        $this->db->join('sales', "sales.sal_user_id = star_users.user_id", 'left');

        $this->db->join('book', "book.bo_id = sales.sal_bo_id", 'left');

        $this->db->order_by("sal_ord", "DESC");

        $this->db->where('sal_user_id', $id);

        $this->db->limit($this->pagination->per_page, $limit);

        return $this->db->get('star_users')->result_array();

    }



    function get_user_visits($limit, $id = '') {

        $this->db->order_by("pa_vi_time", "DESC");

        $this->db->where('pa_vi_userid', $id);

        $this->db->limit($this->pagination->per_page, $limit);

        return $this->db->get('pages_visits')->result_array();

    }



    function get_user_sales_rows($user_id) {

        $this->db->where('sal_user_id', $user_id);

        $result = $this->db->get('sales');

        return $result->num_rows();

    }



    function get_user_visits_rows($user_id) {

        $this->db->where('pa_vi_userid', $user_id);

        $result = $this->db->get('d_pages_visits');

        return $result->num_rows();

    }



//    function get_user_one($id) {

//        $result = $this->db->query("select * from d_star_users where user_id='$id'");

//        return $result->row();

//    }



    function operation() {

        if (!empty($_POST['check_nf'])) {

            $elements = $_POST['check_nf'];

            for ($i = 0; $i <= count($elements) - 1; $i++) {

                switch ($_POST['operation']) {

                    case "delete":

                        $this->delete($elements[$i]);

                        break;

                }

            }

        }

    }



    function get_visitor() {

        $name = $this->input->post('name');

        $email = $this->input->post('email');

        $s = $this->db->query("select * from employee where e_name='$name' and e_email='$email'");

        return $s = $s->result_array();

    }



}



