<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**

 *

 * @property CI_DB_active_record $db

 * @property CI_Input $input

 * @property CI_Pagination $pagination

 * @author Mohamed Mahdy <eng.mohamed.php@gmail.com>

 * @copyright Copyright (c) 2011, Web Developer <Mohamed Mahdy>

 */
class Groups_model extends CI_Model {

    /**

     *

     * static ids cannot be deleted

     *

     * admin = 1

     *

     * publishing = 2

     *

     * site_members = 3

     *

     * @var integer

     *

     */
    private $static_ids;

    function __construct() {

        parent::__construct();

        $this->static_ids = array('1', '3');
    }

    function get_groups($row) {

        $this->db->order_by('gr_id', 'desc');

        $this->db->select('d_groups.*');
        $this->db->limit(10, $row);
        $this->db->from('d_groups');

        $result = $this->db->get();

        return $result->result_array();
    }

    function getNumUsersAdmin() {
        $query = $this->db->query("select * from d_groups");
        return $query->num_rows();
    }

    function get_group($id) {

        $this->db->join('d_group_rights_bridge', 'groups.gr_id=d_group_rights_bridge.gr_group_id', 'left');

        return $this->db->get_where('groups', 'groups.gr_id = ' . $id)->row();
    }

    function get_roles($id) {

        return $this->db->query("

        SELECT DISTINCT d_rights.right_id as right_id ,d_rights.right_title,d_group_rights_bridge.gr_group_id,d_group_rights_bridge.gr_right_id FROM d_rights

        left JOIN d_group_rights_bridge ON d_group_rights_bridge.gr_right_id = d_rights.right_id and d_group_rights_bridge.gr_group_id = $id

        GROUP BY d_rights.right_id

        ")->result_array();

        $sql = 'SELECT DISTINCT id,user,phone GROUP BY id';
    }

    function get_rolesall() {

        return $this->db->query("SELECT DISTINCT d_rights.right_id as right_id,d_rights.* FROM d_rights

                    left JOIN  d_group_rights_bridge ON  d_group_rights_bridge.gr_right_id = d_rights.right_id 

        group by d_rights.right_id

        ")->result_array();
    }

    function create() {

        $this->db->set('gr_name', $this->input->post('group_name'));
        $this->db->set('gr_notice', $this->input->post('group_notice'));

        $this->db->insert('groups');

        $id = $this->db->insert_id();

        if (isset($_POST['group_role'])) {

            $elements = $_POST['group_role'];

            for ($i = 0; $i <= count($elements) - 1; $i++) {

                $this->db->set('gr_group_id', $id);

                $this->db->set('gr_right_id', $elements[$i]);

                $this->db->insert('d_group_rights_bridge');
            }
        }
    }

    /**

     * update group rights

     *

     * @param integer $id  groupid

     */
    function update($id) {

        if (isset($_POST['group_role'])) {

            $this->db->where('gr_id', $id);

            $this->db->set('gr_name', $this->input->post('group_name'));
            $this->db->set('gr_notice', $this->input->post('group_notice'));

            $this->db->update('groups');

            $this->db->where('gr_group_id', $id);

            $this->db->delete('d_group_rights_bridge');



            $elements = $_POST['group_role'];

            for ($i = 0; $i <= count($elements) - 1; $i++) {

                $this->db->set('gr_group_id', $id);

                $this->db->set('gr_right_id', $elements[$i]);

                $this->db->insert('d_group_rights_bridge');

                log_message('log_message', 'rights information has been inserted for group_id = ' . $id);
            }
        } else {

            return FALSE;
        }
    }

    /**

     *

     *  This function delete group's information.

     *

     *  @param integer $id group id

     *

     */
    function delete($id) {

        if (!in_array($id, $this->static_ids)) {

            $this->db->where('gr_id', $id);

            $this->db->delete('groups');


            $this->db->where('gr_group_id', $id);

            $this->db->delete('d_group_rights_bridge');

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function is_valid_visitor($id) {

        $this->db->where('e_id', $id);

        $this->db->from('employee');

        if ($this->db->count_all_results() > 0) {

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function is_valid_page($id) {

        $this->db->where('e_id', $id);

        $this->db->from('employee');

        if ($this->db->count_all_results() > 0) {

            return TRUE;
        } else {

            return FALSE;
        }
    }

    function get_page($id) {

        $this->db->where('e_id', $id);

        $result = $this->db->get('employee');

        if ($result->num_rows() > 0) {

            return $result->row_array();
        } else {

            return FALSE;
        }
    }

    function get_group_one($id) {

        $result = $this->db->query("select * from d_groups where gr_id = '$id'");

        return $result->row();
    }

    function operation() {

        if (!empty($_POST['check_nf'])) {

            $elements = $_POST['check_nf'];

            for ($i = 0; $i <= count($elements) - 1; $i++) {

                switch ($_POST['operation']) {

                    case "delete":

                        $this->delete($elements[$i]);
                        $this->session->set_flashdata('success_msg', $this->lang->line('success_msg_del_all'));
                        break;
                }
            }
        }
    }

    function get_visitor() {

        $name = $this->input->post('name');

        $email = $this->input->post('email');

        $s = $this->db->query("select * from employee where e_name='$name' and e_email='$email'");

        return $s = $s->result_array();
    }

}
