<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Visitors extends Website {



	function __construct(){

            

	   parent::__construct();

         

           $this->lang->load('visitors/visitors_front');

           $this->load->model('visitors_model','visitors');

         

        }



	function index()

	{

            $this->overview();

	}



       

        /* display all visitors in frontend. */

	function overview($row=0)

	{

            $this->load->library('pagination');

            $config['base_url']=base_url()."visitors/overview";

            $config['total_rows']=$this->visitors->getNumUsers();

            $config['per_page']= '10';

            $this->pagination->initialize($config);

            $data['visitors'] = $this->visitors->get_visitors_front($row);

            $data['row']=$row;

            $data['total_rows']=$this->visitors->getNumUsers();

	    $data['links']=$this->pagination->create_links();

            $data['main_content'] = "site/visitors";

            $this->load->view('theme/template', $data);

            

	}

        

       /* add visitor*/

        function add_visitor()

        {

             $this->load->library('upload');

             $this->load->helper('form');

             $this->load->helper('email');

             $this->load->library('email');

             $this->load->library('captcha/captcha');

              $captcha = new Captcha();

            $data['user']=$this->visitors->get_visitor();

            $data['nationality']=$this->visitors->get_nationality();

            $data['country']=$this->visitors->get_country();

            $this->load->library('form_validation');

            $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");

            $this->form_validation->set_rules('name',  lang('visitor_name'), 'trim|required|xss_clean|htmlspecialchars');

            $this->form_validation->set_rules('email', lang('visitor_mail'), 'trim|required|xss_clean|htmlspecialchars|valid_email');

            $this->form_validation->set_rules('captcha', lang('captcha'), 'trim|required|xss_clean');

          

            if($this->form_validation->run()== false){

               $data['form_error'] = "";

               $data['main_content'] = "site/visitor_add";

               $this->load->view('theme/template', $data);

            }else{

                     if($captcha->validate($_POST['captcha']))

                     {

                    if($data['user']!= null)

                        {

                       $data['msg2']=lang('msg_error');

                       $data['main_content'] = "visitors/site/msg";

                       $this->load->view('theme/template', $data);

                        }else{

                       $cv_url = $this->upload_cv('cv_file');

                       $this->visitors->add_visitor($cv_url);

                       $config['mailtpye'] = 'html';

                       $this->email->initialize($config);

                       $this->email->from($this->input->post('email'), $this->input->post('name'));

                       $this->email->to($this->option->get('site_email'));

                       $this->email->subject("متقدم لوظيفة ");

                       $this->email->message("تم ارسال السيرة الذاتية لطلب وظيفة ");

                       $this->email->send();

                       $data['msg']=lang('success_msg');

                       $data['main_content'] = "visitors/site/msg";

                       $this->load->view('theme/template', $data);

                      

                       }

                     }

                 }

        }

    function upload_cv($file)

        {

            $upload_cfg['upload_path'] = 'global/uploads/';

            $upload_cfg['encrypt_name'] = TRUE;

            $upload_cfg['allowed_types'] = 'pdf|doc|docx|rtf';

            $this->upload->initialize($upload_cfg);

            if ($this->upload->do_upload($file))

            {

                $book = $this->upload->data();

                return $book['file_name'];

            }

            else

            {

                return false;

            }



        }

       function visit()

        {

           $data['main_content'] = "visitors/site/visitor_add";

           $this->load->view('theme/template', $data);



        }

       

}



/* End of file dashboard.php */

/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */