<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**

 * @property users_model $users

 */
class Admin_users extends back_end {

    function __construct() {

        parent::__construct();

        $this->lang->load('authorization/users');

        $this->template->metas('page_title', lang('page_title_users'));
        $this->load->library("form_validation");
        $this->load->model('authorization/users_model', 'users');

        //$this->load_form_validation();



       // $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index() {

        $this->overview();
    }

    /* display all visitors in datagrid. */

    function overview($row = 0) {

        $userdata = $this->input->post("userdata");

       // $this->check_right('manage_authorization');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "authorization/admin_users/overview";
        $config['total_rows'] = $this->users->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';


        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->users->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();


        $data['users'] = $this->users->get_users($row, $userdata);

        $this->view('authorization/users_list', $data);
    }

    function create() {

        $this->check_right('manage_authorization', 'admin/dashboard');

        $this->form_validation->set_rules('user_name', lang('user_name'), 'trim|required|xss_clean|htmlspecialchars|callback_is_username_exist');

        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال إسم مستخدم أخر.');

        $this->form_validation->set_rules('user_pass', lang('user_pass'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('name', lang('name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('confirm_pass', lang('confirm_pass'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('email', "البريد الإلكترونى", 'trim|required|xss_clean|htmlspecialchars|valid_email|callback_is_email_exist|max_length[100]');

        $this->form_validation->set_rules('group_id', "المجموعة", 'trim|required|xss_clean');

        $this->form_validation->set_message('is_unique', '%s تم استخدامه من قبل يرجي إعادة إدخال بريد أخر.');

        $data['groups'] = $this->users->get_groups();

        if ($this->form_validation->run() == false) {

            $this->view('user_new', $data);
        } else {

            if ($this->input->post('user_pass') == $this->input->post('confirm_pass')) {

                $this->users->create();

                $this->session->set_flashdata('success_msg', lang('success_msg'));

                redirect('authorization/admin_users/overview/');
            } else {

                $this->session->set_flashdata('error_msg', lang('error_msg'));

                $this->view('user_new', $data);
            }
        }
    }

    /* This function call operation function in visitors_model

      that's executes some operation according to choice. */

    function operation() {

        $this->check_right('manage_authorization');

        $this->users->operation();

        redirect('authorization/admin_users/overview');
    }

    /**

     *

     * @param integer $id

     */
    function remove($id) {

        $this->check_right('manage_authorization');

        if ($this->users->delete($id)) {

            $this->session->set_flashdata('success_msg', lang('success_msg_del'));
        } else {

            $this->session->set_flashdata('notice_msg', lang('cannot_delete_group'));
        }

        redirect('authorization/admin_users/overview/');
    }

    /**

     *

     * @param integer $group_id

     *

     */
    function remove_by_group($group_id) {

        $this->check_right('manage_authorization');

        $users = $this->users->get_users_by_group($group_id);

        foreach ($users as $row) {

            $this->remove($row['user_id']);
        }
    }

    function edit($id) {

        $this->check_right('manage_authorization');



        $data['groups'] = $this->users->get_groups_edit();

        $data['user'] = $this->users->get_user_one($id);



        $this->form_validation->set_rules('user_name', lang('user_name'), 'trim|required|xss_clean|htmlspecialchars|callback_is_username_exist');

        $this->form_validation->set_rules('user_pass', lang('user_pass'), 'trim|xss_clean|matches[confirm_pass]');

        $this->form_validation->set_rules('name', lang('name'), 'trim|required|xss_clean');

        $this->form_validation->set_rules('confirm_pass', lang('confirm_pass'), 'trim|xss_clean');

        $this->form_validation->set_rules('email', "البريد الإلكترونى", 'trim|required|xss_clean|htmlspecialchars|valid_email|callback_is_email_exist|max_length[100]');

        $this->form_validation->set_rules('group_id', "المجموعة", 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {

            $this->view('user_edit', $data);
        } else {

            $this->users->update($id);

            $this->session->set_flashdata('success_msg', lang('data_updated'));

            redirect('authorization/admin_users/overview/');
        }
    }

//    function show($id) {
//        $this->check_right('manage_authorization');
//        $data['user_detail'] = $this->users->get_user_one($id);
//        $this->view('authorization/users_display', $data);
//    }


    function is_username_exist() {
        $result = $this->users->check_username();
        if ($result) {
            if ($this->input->post("user_id")) {
                if ($result->user_id == $this->input->post("user_id")) {
                    return true;
                } else {
                    $this->form_validation->set_message('is_username_exist', '%s مستخدم من قبل');
                    return false;
                }
            } else {
                $this->form_validation->set_message('is_username_exist', '%s مستخدم من قبل');
               return false;
            }
        } else {
            return true;
        }
    }

    function is_email_exist() {
        $result = $this->users->check_email();
        if ($result) {
            if ($this->input->post("user_id")) {
                if ($result->user_id == $this->input->post("user_id")) {
                    return true;
                } else {
                    $this->form_validation->set_message('is_email_exist', 'هذا %s مستخدم من قبل');
                    return false;
                }
            } else {
                $this->form_validation->set_message('is_email_exist', 'هذا %s مستخدم من قبل');
               return false;
            }
        } else {
            return true;
        }
    }

    function show($id, $page = 0) {

        $this->check_right('manage_authorization');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . 'authorization/admin_users/show/' . $id;

        $config['total_rows'] = $this->users->get_user_sales_rows($id);

        $config['per_page'] = '10';

        $config['uri_segment'] = '5';

        $this->pagination->initialize($config);

        $data['page'] = $page;



        $data['user_detail'] = $this->users->get_user_one($id);

        $data['user_sales'] = $this->users->get_user_sales($page, $id);

        $this->view('authorization/users_display', $data);
    }

    function pages_visits($id, $page = 0) {

        $this->check_right('manage_authorization');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . 'authorization/admin_users/pages_visits/' . $id;

        $config['total_rows'] = $this->users->get_user_visits_rows($id);

        $config['per_page'] = '10';

        $config['uri_segment'] = '5';

        $this->pagination->initialize($config);

        $data['page'] = $page;



        $data['user_detail'] = $this->users->get_user_one($id);

        $data['user_visits'] = $this->users->get_user_visits($page, $id);

        $this->view('authorization/user_visits', $data);
    }

}

/* End of file admin_users.php */

/* Location: ./system/application/modules/authorization/controllers/admin_users.php */
