<?php



if (!defined('BASEPATH'))

    exit('No direct script access allowed');



/**

 * @property star_users_model $star_users 

 */

class Admin_star_users extends back_end {



    function __construct() {

        parent::__construct();

        $this->lang->load('authorization/star_users');

        $this->template->metas('page_title', lang('page_title_star_users'));

        $this->load->model('authorization/star_users_model', 'star_users');

        $this->load_form_validation();



        $this->form_validation->set_error_delimiters("<span class='notification-input ni-error'>", "</span>");

    }



    function index() {

        $this->overview();

    }



    /* display all visitors in datagrid. */



    function overview() {

        $userdata = $this->input->post("userdata");

        $this->check_right('manage_authorization');

        $data['user_offers'] = $this->star_users->get_user_offers($userdata);

        $this->view('authorization/star_users_list', $data);

    }



    function create($user_id) {

        $data["user_id"] = $user_id;

        

        $this->check_right('manage_authorization', 'admin/dashboard');

        $this->form_validation->set_rules('book_id', lang('book_id'), 'trim|required|xss_clean|htmlspecialchars|callback_is_book_exist|callback_is_book_offered');

        $this->form_validation->set_rules('book_free', lang('book_free'), 'required');

        if ($this->input->post("book_free") == "2") {

            $this->form_validation->set_rules('book_discount', lang('book_discount'), 'trim|required|xss_clean|htmlspecialchars');

        }





        if ($this->form_validation->run() == false) {

            $this->view('star_user_new', $data);

        } else {

            $this->star_users->create($user_id);

            $this->session->set_flashdata('success_msg', lang('success_msg'));

            redirect('authorization/admin_star_users/user_offers/' . $user_id);

        }

    }



    function is_book_exist() {

        $bo_id = $this->input->post('book_id');        

        if (!$this->star_users->is_book_exist($bo_id)) {

            $this->form_validation->set_message("is_book_exist", "هذا الكتاب غير موجود");

            return FALSE;            

        } else {

            return TRUE;            

        }

    }

    

    function is_book_offered() {

        

        $bo_id = $this->input->post('book_id'); 

        $user_id = $this->input->post('user_id'); 

        if ($this->star_users->is_book_offered($bo_id, $user_id)) {

            $this->form_validation->set_message("is_book_offered", "هذا الكتاب مضاف له عرض لهذا المستخدم");

            return FALSE;            

        } else {

            return TRUE;            

        }

    }

    /* This function call operation function in visitors_model

      that's executes some operation according to choice. */



    function operation($user_id) {

        $this->check_right('manage_authorization');

        $this->star_users->operation();

        redirect('authorization/admin_star_users/user_offers/' . $user_id);

    }



    /**

     * 

     * @param integer $id 

     */

    function remove($offer_id) {

        $this->check_right('manage_authorization');

        $star_user = $this->star_users->get_star_user_one($offer_id);

//        print_r($star_user);exit;

        $user_id = $star_user->st_us_userid;

        if ($this->star_users->delete($offer_id)) {          

            $this->session->set_flashdata('success_msg', lang('success_msg_del'));

        } else {

            $this->session->set_flashdata('notice_msg', "dsadas".lang('cannot_delete_group'));

        }

//          echo lang('success_msg_del');exit;

        redirect('authorization/admin_star_users/user_offers/' . $user_id);

    }



    function edit($offer_id) {

        $this->check_right('manage_authorization');



        $data['star_user'] = $this->star_users->get_star_user_one($offer_id);

        $data["user_id"] = $data['star_user']->st_us_userid;

        $data["offer_id"] = $offer_id;



        $this->form_validation->set_rules('book_id', lang('book_id'), 'trim|required|xss_clean|htmlspecialchars');

        $this->form_validation->set_rules('book_free', lang('book_free'), 'required');

        if ($this->input->post("book_free") == "2") {

            $this->form_validation->set_rules('book_discount', lang('book_discount'), 'trim|required|xss_clean|htmlspecialchars');

        }



        if ($this->form_validation->run() == false) {

            $this->view('star_user_edit', $data);

        } else {

            $this->star_users->update($offer_id);

            $this->session->set_flashdata('success_msg', lang('data_updated'));

            redirect('authorization/admin_star_users/user_offers/' . $data["user_id"]);

        }

    }



    function user_offers($user_id) {

        $data["user_id"] = $user_id;

        $this->check_right('manage_authorization');

        $data['user_offers'] = $this->star_users->get_user_offers($user_id);

        $this->view('authorization/user_offers', $data);

    }



}



/* End of file admin_star_users.php */

/* Location: ./system/application/modules/authorization/controllers/admin_star_users.php */