<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**

 * @property groups_model $groups 

 */
class Admin_groups extends back_end {

    function __construct() {

        parent::__construct();

        $this->check_right('manage_authorization', 'admin/dashboard');

        $this->lang->load('authorization/groups');

        $this->template->metas('page_title', lang('page_title_users'));

        $this->load->model('groups_model', 'groups');

        $this->load->library('form_validation');

        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
    }

    function index() {



        $this->overview();
    }

    /* display all visitors in datagrid. */

    function overview($row = 0) {
        $this->auth->check('manage_authorization');

        $this->load->library('pagination');

        $config['base_url'] = base_url() . "authorization/admin_groups/overview";
        $config['total_rows'] = $this->groups->getNumUsersAdmin();
        $config['per_page'] = '10';
        $config['uri_segment'] = 4;

        $config['full_tag_open'] = '<div class="pages">';
        $config['full_tag_close'] = '</div>';

        $config['cur_tag_open'] = '<a href="javascript:void(0)" class="current">';
        $config['cur_tag_close'] = '</a>';

        $config['first_link'] = '&lt;&lt; الأولى';
        $config['last_link'] = 'الأخيرة &gt;&gt;';


        $this->pagination->initialize($config);

        $data['row'] = $row;
        $data['total_rows'] = $this->groups->getNumUsersAdmin();
        $data['links'] = $this->pagination->create_links();


        $data['groups'] = $this->groups->get_groups($row);

        $this->view('authorization/groups_list', $data);
    }

    function create() {

        $this->auth->check('manage_authorization');

        $this->form_validation->set_rules('group_name', lang('group_name'), 'trim|required|xss_clean|htmlspecialchars');
        $this->form_validation->set_rules('group_notice', lang('group_notice'), 'trim|xss_clean|htmlspecialchars');

        // $this->form_validation->set_rules('group_role', lang('group_role'), 'trim|required|xss_clean');

        $data['roles'] = $this->groups->get_rolesall();

        if ($this->form_validation->run() == false) {

            $this->view('group_new', $data);
        } else {

            $this->groups->create();

            $this->session->set_flashdata('success_msg', lang('success_msg'));

            redirect('authorization/admin_groups/overview/');
        }
    }

    /* This function call operation function in visitors_model

      that's executes some operation according to choice. */

    function operation() {

        $this->groups->operation();

        redirect('authorization/admin_groups/overview');
    }

    /* This function remove visitor in database. */

    function remove($id) {
        $this->auth->check('manage_authorization');

        if ($this->groups->delete($id)) {

            Modules::run('authorization/admin_users/remove_by_group', $id);

            $this->session->set_flashdata('success_msg', lang('success_msg_del'));
        } else {

            $this->session->set_flashdata('notice_msg', lang('cannot_delete_user'));
        }

        redirect('authorization/admin_groups/overview/');
    }

    /**

     * @param integer $id 

     */
    function edit($id) {

        $this->auth->check('manage_authorization', 'cp/dashboard');

        $data['roles'] = $this->groups->get_roles($id);

        $data['group'] = $this->groups->get_group($id);

        $data['id'] = $id;

        $this->form_validation->set_rules('group_name', lang('group_name'), 'trim|required|xss_clean|htmlspecialchars');

        if ($this->form_validation->run() === FALSE) {

            $this->view('group_edit', $data);
        } else {

            $this->groups->update($id);

            $this->session->set_flashdata('success_msg', lang('Data_updated'));

            redirect('authorization/admin_groups/overview/');
        }

        //$this->view('group_edit',$data);
    }

    /**

     *

     * @param integer $id 

     */
    function show($id) {
        $this->auth->check('manage_authorization');

//    $this->auth->check('manage_authorization', 'cp/dashboard');

        $data['group_detail'] = $this->groups->get_group_one($id);

        $this->view('authorization/group_display', $data);
    }

}

/* End of file dashboard.php */

/* Location: ./system/application/modules/matchbox/controllers/dashboard.php */