<?php

class Settings extends back_end {

    function __construct()
    {
        parent::__construct();
        $this->auth->check('manage_edit_config','admin/dashboard');       
        $this->template->metas('page_title', 'اعدادت الموقع');
    }

    function index()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('site_name', 'عنوان الموقع', 'trim|required|xss_clean');
        $this->form_validation->set_rules('admin_panel_title', 'عنوان لوحة التحكم', 'trim|required|xss_clean');
        $this->form_validation->set_rules('site_email', 'البريد الالكترونى', 'trim|required|valid_email|xss_clean');
        $this->form_validation->set_rules('site_keywords', ' الكلمات المفتاحية', 'trim|required|xss_clean');
        $this->form_validation->set_rules('site_description', 'وصف الموقع ', 'trim|required|xss_clean');

        if($this->form_validation->run() == FALSE)
        {
            $data['SiteTitle'] = $this->option->get('site_name');
            $data['AdminTitle'] = $this->option->get('admin_panel_title');
            $data['SiteEmail'] = $this->option->get('site_email');
            $data['SiteKeywords'] = $this->option->get('site_keywords');
            $data['SiteDescription'] = $this->option->get('site_description');
            
            $this->view('admin/site_settings', $data);
        }else{
            $this->option->update('site_name', $this->input->post('site_name'));
            $this->option->update('admin_panel_title', $this->input->post('admin_panel_title'));
            $this->option->update('site_email', $this->input->post('site_email'));
            $this->option->update('site_keywords', $this->input->post('site_keywords'));
            $this->option->update('site_description', $this->input->post('site_description'));
            
            $this->session->set_flashdata('success_msg', 'تم تعديل الاعدادات بنجاح');
            redirect('admin/settings/');
        }
    }

 }

/* End of file settings.php */
/* Location: ./application/controllers/admin/Settings.php */

