<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Profile extends back_end
{
    /**
     * Constructor
     *
     * @access	public
     */
    function __construct()
    {
        parent::__construct();
        $this->auth->check('manage_edit_profile','admin/dashboard');
        $this->load->model('users/users_model', 'user');
        $this->template->metas('page_title', 'الملف الشخصى');
    }
 
    function index()
    {
        $user_id  = $this->auth->get_user_id();
        $user_info = $this->user->get_user_data($user_id);
        
        $data['user'] = $user_info;
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters("<span class='incorrect'>", "</span>");
        $this->form_validation->set_rules('name', 'اسم المستخدم', 'trim|strip_tags|xss_clean|max_length[100]');
        $this->form_validation->set_rules('email', 'البريد الالكترونى', 'trim|required|valid_email');
        $this->form_validation->set_rules('password', 'كلمة المرور', 'trim|xss_clean');
        $this->form_validation->set_rules('passwordconf', 'تأكيد كلمة المرور', 'trim|matches[password]');

        if ($this->form_validation->run() == FALSE)
        {
            $this->view('admin/profile_edit', $data);
        }
        else
        {
            $this->user->update_profile($user_id);
            $this->session->set_flashdata('success_msg', 'تم حفظ بيانات الملف الشخصى بنجاح');
            redirect('admin/profile/');
        }

    } 
    /** 
      * Check Current Password
      *
      * @access	public
      * @param	string	password
      * @return	bool
      */
    function check_password($pass)
    {
            if ($this->auth->login($this->auth->get_username, md5($pass)) !== TRUE)
            {
                    $this->form_validation->set_message('check_password', 'كلمة المرور الحالية خاطئة');
                    return FALSE;
            }
            else
            {
                    return TRUE;
            }
    }
}

/* End of file profile.php */
/* Location: ./application/controllers/admin/profile.php */

