<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Backup extends back_end {

    // Constructor
    public function __construct() {
        parent::__construct();

        if (!$this->auth->is_logged_in()) {
            $this->session->set_flashdata('error_msg', 'يجب عليك تسجيل الدخول أولا');
            redirect('admin');
        }

        $this->load->dbutil();
        $this->load->helper('download');
    }

    public function index() {
        $backup = & $this->dbutil->backup();
        $file_name = 'dt4it-' . @date('Y-m-d') . '.sql.gz';

        force_download($file_name, $backup);
    }

}

/* End of file backup.php */
/* Location: ./application/modules/admin/controllers/backup.php */

