<?php

if (!defined('BASEPATH'))
    exit('No direct script access alloweda');

class Template {

    private $CI;

    /**
     * Template Constructor
     *
     * @access	public
     */
    function __construct() {
        // Get CodeIgniter instance
        $this->CI = & get_instance();

        // Set default variables
        $this->set_defaults();
    }

    // ------------------------------------------------------------------------

    /**
     * Set Default Variables
     *
     * @access	public
     */
    function set_defaults() {
        // Defaut meta tags
        $this->metas();
        // Default template variables
        $data['flash_data'] = 'flashdata';

// Set variables globally
        $this->CI->load->vars($data);
    }

    // ------------------------------------------------------------------------

    /**
     * Set Meta Tags
     *
     * @access	public
     * @param	array	meta tags
     * @return	associative array of meta tags
     */
    function metas($metas = array(), $value = '') {
        if (!is_array($metas)) {
            $metas = array($metas => $value);
        }

        // Get default metas from the config file
        $default_metas = array(
            'page_title' => $this->CI->config->item('default_title'),
            'description' => $this->CI->config->item('default_description'),
            'keywords' => $this->CI->config->item('default_keywords')
        );

        // Overwrite default metas where possible
        $metas = array_merge($default_metas, $metas);
//        $this->CI->session->set_userdata("set_page_title", $metas["page_title"]);
        $this->CI->load->vars($metas);
        return $metas;
    }

    function admin_header() {
        return $this->CI->load->view('admin/header');
    }

    function admin_footer() {
        return $this->CI->load->view('admin/footer');
    }

    function site_header() {
        return $this->CI->load->view('header');
    }

    function site_footer() {
        return $this->CI->load->view('footer');
    }

    function menu() {
        return $this->CI->load->view('menu');
    }

    function flash_msg() {
        return $this->CI->load->view('admin/flashdata');
    }

    function site_header_en() {
        return $this->CI->load->view('header_en');
    }

    function site_footer_en() {
        return $this->CI->load->view('footer_en');
    }

    function menu_en() {
        return $this->CI->load->view('menu_en');
    }

}

/* End of file Template.php */
/* Location: ./application/libraries/Template.php */

