<?php

(defined('BASEPATH')) OR exit('No direct script access allowed');

/**
 * @property Tools $tools
 * @property CI_Config $config
 * @property CI_Language $lang
 * @property CI_Session $session
 */
class Front_end extends main {

    /**
     * pages of site in menu
     */
    public $pagesmenu;

    function __construct() {
        parent::__construct();        

        if (isset($lang_string)) {
            $this->set_lang_sess($lang_string);
        }
        $vars['page_title'] = 'الرئيسية';

        $vars['description'] = $this->option->get('site_description');

        $vars['keywords'] = $this->option->get('site_keywords');

        

        $this->load->vars($vars);

        $this->lang->load('header');
        $this->pagesmenu = Modules::run("pages/pages/fetch_pages");
    }

    /**
     * <a href='<?= base_url()?>site/ar'>arabic</a>
     * <a href='<?= base_url()?>site/en'>english</a>
     * @param string $lang_string  ar or en
     */
    function set_lang_sess($lang_string = '') {
        if (isset($lang_string)) {
            $this->session->set_flashdata('lang', $lang_string);
        } else {
            $this->session->set_flashdata('lang', 'ar');
        }
    }

    /**
     * return module language file 
     * @param String $moduleName
     */
    protected function load_lang($moduleName = '') {
        if ($this->session->userdata('lang') == "ar") {
            $lang = "arabic";
        } else {
            $lang = "english";
        }
        $this->lang->load($moduleName, $lang);
    }

    /**
     * present master page includes header and footer
     * @param string $main_containt
     * @param array $data 
     */
    protected function view($main_containt, $data = null) {
        $this->load->view('theme/header');
        $this->load->view('theme/rmenu');
        $this->load->view($main_containt, $data);
        $this->load->view('theme/footer');
    }

    /**
     * give it the right string and it will 
     * @param string $right
     * @return void
     */
    protected function check_right($right, $path = '') {
        if ($path) {
            $this->auth->check($right, $path);
        } else {
            $this->auth->check($right, 'site');
        }
    }

}