<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Auth Class
 *
 * This class provides a lightweight Authentication/Authorization system
 *
 * @package		ebook
 * @category            Libraries
 * @author		Ahmed El-Sebaey
 * @link		http://dt4it.com
 * @version 	1.1
 */
class Auth {

    public $user = FALSE;
    public $rights = FALSE;
    public $salt;
    public $hashPasswd;
    private $CI;

    public function __construct() {
        $this->CI = & get_instance();
        $this->salt = $this->CI->config->item('encryption_key');
        $this->hashPasswd = $this->CI->config->item('auth_hash_password');
        $this->refresh();
    }

    function is_logged_in() {
        return is_array($this->user);
    }

    Private function refresh() {
        $user_id = $this->CI->session->userdata('user');

        if ($user_id) {
            $this->user = $this->get_user($user_id);
        }

        $this->_get_rights($user_id);
    }

    Public function login($username, $password) {
        $this->CI->db->where('user_username', $username);
        $this->CI->db->where('user_password', $password);
        $result = $this->CI->db->get('d_users');

        if ($result->num_rows() > 0) {
            $this->user = $result->row_array();
            $this->CI->session->set_userdata('user', $this->user['user_id']);
            $this->CI->session->set_userdata('username', $this->user['user_username']);
        }

        return $this->is_logged_in();
    }

    public function logout() {
        $this->user = FALSE;
        $this->CI->session->unset_userdata('user');
        return TRUE;
    }

    public function get_username() {
        if ($this->is_logged_in()) {

            return $this->CI->session->userdata('username');
        } else {
            return FALSE;
        }
    }

    public function get_user_id() {
        if ($this->is_logged_in()) {
            return $this->user['user_id'];
        } else {
            return FALSE;
        }
    }

    public function get_user($user_id = '') {
        if ($this->is_logged_in() && $user_id == '') {
            $user_id = $this->get_user_id();
        }
        $this->CI->db->where('user_id', $user_id);
        $result = $this->CI->db->get('d_users');
        $user = $result->row_array();
        return $user;
    }

    public function get_group($user_id = '') {
        if ($this->is_logged_in() && $user_id == '') {
            $user_id = $this->get_user_id();
        }
        $this->CI->db->where('ug_user_id', $user_id);
        $result = $this->CI->db->get('d_user_groups');
        $group = $result->row();
        if (is_object($group)) {
            return $group->ug_group_id;
        } else {
            $msg_error = "cannot get user group id";
            echo $msg_error;
            log_message('error', 'cannot get user group id');
            exit;
        }
    }

    public function is_active($username) {
        $this->CI->db->where('user_username', $username);
        $result = $this->CI->db->get('d_users');
        if ($result->num_rows() > 0) {
            $row = $result->row();
            return $row->is_active;
        } else {
            return FALSE;
        }
    }

    private function _get_rights($user_id = FALSE) {
        if ($this->is_logged_in()) {
            $this->CI->db->distinct();
            $this->CI->db->where('ug_user_id', $user_id);
            $this->CI->db->from('d_user_groups');
            $this->CI->db->join('d_group_rights_bridge', 'gr_group_id = ug_group_id');
            $this->CI->db->join('d_rights', 'right_id = gr_right_id');

            $result = $this->CI->db->get();
            if ($result->num_rows() > 0) {
                $this->rights = array();
                foreach ($result->result_array() as $right) {
                    $this->rights[$right['right_name']] = TRUE;
                }
            } else {
                $this->rights = FALSE;
            }
        }
    }

    public function has_right($right) {
        if ($this->rights == FALSE) {
            return FALSE;
        } else {
            if (is_array($right)) {
                foreach ($right as $value) {
                    if (isset($this->rights[$value])) {
                        return TRUE;
                    }
                }
            } else {
                return isset($this->rights[$right]);
            }
        }
    }

    function check($right, $path = NULL) {
        if ($this->has_right($right)) {
            return TRUE;
        } else {
            $this->CI->session->set_flashdata('attention_msg', 'ليست لديك الصلاحيات الكافية لاستخدام هذه الخاصية');
        }
        redirect($path);
    }

    public function hash_password($passwd) {
        $this->CI->load->helper('security');

        $passwd = $this->hashPasswd ? dohash($passwd . $this->salt) : $passwd;

        return $passwd;
    }

}
