<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * CodeIgniter Directory Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/directory_helper.html
 */

// ------------------------------------------------------------------------
/**
 * CodeIgniter Directory Helpers
 *
 * @param string $dir
 * @return boolean Returns true on success or false on failure
 */
if(! function_exists("deleteDirectory"))
{
      function deleteDirectory($dir) {
            if (!file_exists($dir)) return true;
            if (!is_dir($dir) || is_link($dir)) return unlink($dir);
            foreach (scandir($dir) as $item) {
                if ($item == '.' || $item == '..') continue;
                if (!deleteDirectory($dir . "/" . $item)) {
                    chmod($dir . "/" . $item, 0777);
                    if (!deleteDirectory($dir . "/" . $item)) return false;
                };
            }
            return rmdir($dir);
      }
}
/* End of file directory_helper.php */
/* Location: ./system/helpers/directory_helper.php */